/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.integration.emi.recipes;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.integration.emi.DataNEssenceEMIPlugin;
import com.cmdpro.datanessence.recipe.MeltingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class EMIMeltingRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final int time;

    public EMIMeltingRecipe(ResourceLocation id, MeltingRecipe recipe) {
        this.id = id;
        this.input = recipe.getIngredients().stream().map(s -> EmiIngredient.of(Arrays.stream(s.getItems()).map(EmiStack::of).toList())).toList();
        this.output = List.of(EmiStack.of((Fluid)recipe.getOutput().getFluid(), (long)recipe.getOutput().getAmount()));
        this.time = recipe.getTime();
    }

    public EmiRecipeCategory getCategory() {
        return DataNEssenceEMIPlugin.MELTING;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 123;
    }

    public int getDisplayHeight() {
        return 60;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        ResourceLocation background = DataNEssence.locate("textures/gui/data_tablet_crafting2.png");
        widgetHolder.addTexture(background, 0, 0, this.getDisplayWidth(), this.getDisplayHeight(), 10, 196);
        widgetHolder.addSlot(this.input.get(0), 29, 21).drawBack(false);
        widgetHolder.addSlot((EmiIngredient)this.output.get(0), 73, 21).recipeContext((EmiRecipe)this).drawBack(false);
        widgetHolder.addText((Component)Component.translatable((String)"emi.datanessence.time_seconds", (Object[])new Object[]{(double)this.time / 20.0}), 82, 44, 0xFFFFFF, false).horizontalAlign(TextWidget.Alignment.CENTER);
    }
}

