/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.integration.emi.recipes;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.integration.emi.DataNEssenceEMIPlugin;
import com.cmdpro.datanessence.recipe.MineralPurificationRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class EMIMineralPurificationRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final int time;

    public EMIMineralPurificationRecipe(ResourceLocation id, MineralPurificationRecipe recipe) {
        this.id = id;
        this.input = recipe.getIngredients().stream().map(s -> EmiIngredient.of(Arrays.stream(s.getItems()).map(EmiStack::of).toList())).toList();
        this.output = List.of(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())), EmiStack.of((ItemStack)recipe.getNuggetOutput((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
        this.time = recipe.getTime();
    }

    public EmiRecipeCategory getCategory() {
        return DataNEssenceEMIPlugin.MINERAL_PURIFICATION;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 123;
    }

    public int getDisplayHeight() {
        return 60;
    }

    public void addWidgets(WidgetHolder widgets) {
        ResourceLocation background = DataNEssence.locate("textures/gui/data_tablet_crafting2.png");
        ResourceLocation emiIcons = DataNEssence.locate("textures/gui/emi_icons.png");
        widgets.addTexture(background, 0, 0, this.getDisplayWidth(), this.getDisplayHeight(), 10, 136);
        EmiStack primary = this.output.get(0);
        EmiStack secondary = this.output.get(1);
        double yield = !primary.isEqual(secondary) ? (double)primary.getAmount() * (1.45 * (double)secondary.getAmount()) : (double)primary.getAmount() * (4.5 * (double)secondary.getAmount());
        widgets.addText((Component)Component.translatable((String)"emi.datanessence.average_yield"), 118, 2, -26955, false).horizontalAlign(TextWidget.Alignment.END);
        widgets.addText((Component)Component.literal((String)String.valueOf(yield)), 118, 12, -26955, false).horizontalAlign(TextWidget.Alignment.END);
        widgets.addSlot(this.input.get(0), 29, 21).drawBack(false);
        widgets.addSlot((EmiIngredient)primary, 73, 14).recipeContext((EmiRecipe)this).drawBack(false);
        widgets.addSlot((EmiIngredient)secondary, 73, 38).recipeContext((EmiRecipe)this).drawBack(false);
        widgets.addTexture(emiIcons, 94, 43, 8, 8, 128, 16).tooltipText(List.of(Component.translatable((String)"emi.datanessence.nugget_mult")));
        widgets.addText((Component)Component.translatable((String)"emi.datanessence.time_seconds", (Object[])new Object[]{(double)this.time / 20.0}), 38, 50, 0xFFFFFF, false).horizontalAlign(TextWidget.Alignment.CENTER);
    }
}

