/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.integration.emi.recipes;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceBarBackgroundTypes;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.integration.emi.DataNEssenceEMIPlugin;
import com.cmdpro.datanessence.integration.emi.DataNEssenceEMIRecipe;
import com.cmdpro.datanessence.integration.emi.widgets.EssenceBarWidget;
import com.cmdpro.datanessence.recipe.SynthesisRecipe;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class EMISynthesisRecipe
extends DataNEssenceEMIRecipe {
    private final Map<EssenceType, Float> essenceCost;
    private final int time;

    public EMISynthesisRecipe(ResourceLocation id, SynthesisRecipe recipe) {
        super(DataNEssenceEMIPlugin.SYNTHESIS, id, recipe.getEntry(), 123, 60);
        this.inputs = recipe.getIngredients().stream().map(s -> EmiIngredient.of(Arrays.stream(s.getItems()).map(EmiStack::of).toList())).toList();
        this.outputs = List.of(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
        this.essenceCost = new HashMap<EssenceType, Float>();
        for (Map.Entry<ResourceLocation, Float> i : recipe.getEssenceCost().entrySet()) {
            this.essenceCost.put((EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get(i.getKey()), i.getValue());
        }
        this.time = recipe.getTime();
    }

    public int getDisplayWidth() {
        return 123;
    }

    public int getDisplayHeight() {
        return 60;
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgetHolder) {
        ResourceLocation background = DataNEssence.locate("textures/gui/data_tablet_crafting.png");
        widgetHolder.addTexture(background, 0, 0, this.getDisplayWidth(), this.getDisplayHeight(), 133, 76);
        widgetHolder.addSlot((EmiIngredient)this.inputs.get(0), 37, 10).drawBack(false);
        widgetHolder.addSlot((EmiIngredient)this.inputs.get(1), 37, 32).drawBack(false);
        widgetHolder.addSlot((EmiIngredient)this.outputs.get(0), 81, 21).recipeContext((EmiRecipe)this).drawBack(false);
        widgetHolder.addText((Component)Component.translatable((String)"emi.datanessence.time_seconds", (Object[])new Object[]{(double)this.time / 20.0}), 90, 44, 0xFFFFFF, false).horizontalAlign(TextWidget.Alignment.CENTER);
        widgetHolder.add((Widget)new EssenceBarWidget(5, 6, EssenceTypeRegistry.ESSENCE.get(), this.essenceCost.getOrDefault(EssenceTypeRegistry.ESSENCE.get(), Float.valueOf(0.0f)).floatValue(), 1000.0f, EssenceBarBackgroundTypes.INDUSTRIAL));
        widgetHolder.add((Widget)new EssenceBarWidget(13, 6, EssenceTypeRegistry.LUNAR_ESSENCE.get(), this.essenceCost.getOrDefault(EssenceTypeRegistry.LUNAR_ESSENCE.get(), Float.valueOf(0.0f)).floatValue(), 1000.0f, EssenceBarBackgroundTypes.INDUSTRIAL));
        widgetHolder.add((Widget)new EssenceBarWidget(5, 32, EssenceTypeRegistry.NATURAL_ESSENCE.get(), this.essenceCost.getOrDefault(EssenceTypeRegistry.NATURAL_ESSENCE.get(), Float.valueOf(0.0f)).floatValue(), 1000.0f, EssenceBarBackgroundTypes.INDUSTRIAL));
        widgetHolder.add((Widget)new EssenceBarWidget(13, 32, EssenceTypeRegistry.EXOTIC_ESSENCE.get(), this.essenceCost.getOrDefault(EssenceTypeRegistry.EXOTIC_ESSENCE.get(), Float.valueOf(0.0f)).floatValue(), 1000.0f, EssenceBarBackgroundTypes.INDUSTRIAL));
    }
}

