/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.node.item.INodeUpgrade;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.screen.FilterNodeUpgradeMenu;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.Nullable;

public class FilterNodeUpgrade
extends Item
implements INodeUpgrade {
    public FilterNodeUpgrade(Item.Properties pProperties) {
        super(pProperties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        ItemContainerContents handler = (ItemContainerContents)stack.get(DataComponentRegistry.FILTER_STACK);
        if (handler != null && handler.getSlots() >= 1) {
            ItemStack filterStack = handler.getStackInSlot(0);
            tooltipComponents.addAll(this.getTooltipForFilter(filterStack));
        }
    }

    public List<Component> getTooltipForFilter(ItemStack filterStack) {
        Optional fluid = FluidUtil.getFluidContained((ItemStack)filterStack);
        if (fluid.isPresent()) {
            return List.of(this.applyFilterTooltipStyle(((FluidStack)fluid.get()).getHoverName()));
        }
        return List.of(this.applyFilterTooltipStyle(filterStack.getHoverName()));
    }

    public Component applyFilterTooltipStyle(Component component) {
        return component.copy().withStyle(ChatFormatting.LIGHT_PURPLE);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, final Player pPlayer, final InteractionHand pUsedHand) {
        if (!pLevel.isClientSide) {
            pPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.empty();
                }

                @Nullable
                public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer2) {
                    return new FilterNodeUpgradeMenu(pContainerId, pPlayerInventory, pPlayer.getItemInHand(pUsedHand));
                }
            }, buf -> buf.writeInt(pPlayer.getInventory().findSlotMatchingItem(pPlayer.getItemInHand(pUsedHand))));
        }
        return InteractionResultHolder.sidedSuccess((Object)pPlayer.getItemInHand(pUsedHand), (boolean)pLevel.isClientSide);
    }

    @Override
    public Object getValue(ItemStack upgrade, ResourceLocation id, Object originalValue, BlockEntity node) {
        ItemContainerContents handler;
        if (id.equals((Object)DataNEssence.locate("allowed_itemstacks")) && (handler = (ItemContainerContents)upgrade.get(DataComponentRegistry.FILTER_STACK)) != null && handler.getSlots() > 0) {
            if (handler.getStackInSlot(0).isEmpty()) {
                return originalValue;
            }
            return List.of(handler.getStackInSlot(0));
        }
        if (id.equals((Object)DataNEssence.locate("allowed_fluidstacks")) && (handler = (ItemContainerContents)upgrade.get(DataComponentRegistry.FILTER_STACK)) != null && handler.getSlots() > 0) {
            if (handler.getStackInSlot(0).isEmpty()) {
                return originalValue;
            }
            Optional fluid = FluidUtil.getFluidContained((ItemStack)handler.getStackInSlot(0));
            if (fluid.isPresent()) {
                return List.of((FluidStack)fluid.get());
            }
        }
        return originalValue;
    }

    @Override
    public INodeUpgrade.Type getType() {
        return INodeUpgrade.Type.UNIQUE;
    }
}

