/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item.equipment;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.item.AdjustableAttributes;
import com.cmdpro.datanessence.api.item.ItemEssenceContainer;
import com.cmdpro.datanessence.entity.EssenceSlashProjectile;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.registry.EntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.ItemRegistry;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.SimpleTier;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;

public class EssenceSword
extends SwordItem
implements AdjustableAttributes {
    public static final Tier ESSENCE_SWORD = new SimpleTier(BlockTags.INCORRECT_FOR_IRON_TOOL, 0, 0.0f, 0.0f, 14, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.ESSENCE_SHARD.get()}));
    public static ResourceLocation FUEL_ESSENCE_TYPE = DataNEssence.locate("essence");
    final int COST_SLASH = 100;
    final int COST_HIT = 10;

    public EssenceSword(Item.Properties properties) {
        super(ESSENCE_SWORD, properties.rarity(Rarity.UNCOMMON).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false)).component(DataComponentRegistry.ESSENCE_STORAGE, (Object)new ItemEssenceContainer(List.of(FUEL_ESSENCE_TYPE), 2500.0f)));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        boolean canHit;
        boolean bl = canHit = ItemEssenceContainer.getEssence(stack, FUEL_ESSENCE_TYPE) >= 10.0f;
        if (canHit) {
            ItemEssenceContainer.removeEssence(stack, FUEL_ESSENCE_TYPE, 10.0f);
        }
        return canHit;
    }

    @Override
    public void adjustAttributes(ItemAttributeModifierEvent event) {
        ItemStack blade = event.getItemStack();
        float damage = ItemEssenceContainer.getEssence(blade, FUEL_ESSENCE_TYPE) >= 10.0f ? 6.0f : 0.0f;
        event.replaceModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(DataNEssence.locate("lightslash_kukri_damage"), (double)damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        event.replaceModifier(Attributes.ATTACK_SPEED, new AttributeModifier(DataNEssence.locate("lightslash_kukri_speed"), (double)1.8f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(ItemRegistry.ESSENCE_SHARD.get());
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemEssenceContainer.getEssence(stack, FUEL_ESSENCE_TYPE) >= 10.0f && super.canPerformAction(stack, itemAbility);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return ItemEssenceContainer.getEssence(stack, FUEL_ESSENCE_TYPE) < 10.0f;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (!pLevel.isClientSide && ItemEssenceContainer.getEssence(stack, FUEL_ESSENCE_TYPE) >= 100.0f) {
            ItemEssenceContainer.removeEssence(stack, FUEL_ESSENCE_TYPE, 100.0f);
            EssenceSlashProjectile slash = new EssenceSlashProjectile(EntityRegistry.ESSENCE_SLASH_PROJECTILE.get(), (LivingEntity)pPlayer, pLevel);
            slash.setPos(slash.position().offsetRandom(pPlayer.getRandom(), 0.25f));
            pLevel.addFreshEntity((Entity)slash);
            pPlayer.getCooldowns().addCooldown((Item)this, 20);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)pLevel.isClientSide);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"item.datanessence.essence_sword.tooltip_1", (Object[])new Object[]{Component.literal((String)String.valueOf(10)).withColor(-26955)}).withStyle(Style.EMPTY.withColor(EssenceTypeRegistry.ESSENCE.get().getColor())));
        tooltipComponents.add((Component)Component.translatable((String)"item.datanessence.essence_sword.tooltip_2", (Object[])new Object[]{Component.literal((String)String.valueOf(100)).withColor(-26955)}).withStyle(Style.EMPTY.withColor(EssenceTypeRegistry.ESSENCE.get().getColor())));
    }
}

