/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item.equipment;

import com.cmdpro.datanessence.block.technical.StructureProtectorBlockEntity;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.registry.TagRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class HammerAndChisel
extends Item {
    public HammerAndChisel(Item.Properties properties) {
        super(properties);
    }

    public boolean chiselBlock(Level world, BlockPos target, ItemStack stack, Player player) {
        BlockState targetState = world.getBlockState(target);
        if (targetState.is(TagRegistry.Blocks.HAMMER_AND_CHISEL_COLLECTABLE)) {
            stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            return true;
        }
        return false;
    }

    public boolean isPositionStructureProtected(Level world, BlockPos pos) {
        if (world.hasData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS)) {
            List protectors = (List)world.getData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS);
            for (StructureProtectorBlockEntity thisProtector : protectors) {
                AABB aabb = AABB.encapsulatingFullBlocks((BlockPos)thisProtector.getCorner1(), (BlockPos)thisProtector.getCorner2());
                if (!aabb.contains(pos.getCenter())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hammerBlock(Level world, BlockPos target, ItemStack stack, Player player, EquipmentSlot hand) {
        BlockState targetState = world.getBlockState(target);
        if (targetState.is(TagRegistry.Blocks.HAMMER_AND_CHISEL_COLLECTABLE) && !this.isPositionStructureProtected(world, target)) {
            stack.hurtAndBreak(1, (LivingEntity)player, hand);
            world.destroyBlock(target, true);
            return true;
        }
        return false;
    }

    public void playSound(Level world, BlockPos target) {
        world.playSound(null, target, (SoundEvent)SoundRegistry.HAMMER_AND_CHISEL_MINE.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public InteractionResult useOn(UseOnContext context) {
        EquipmentSlot hand;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        EquipmentSlot equipmentSlot = hand = context.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (this.hammerBlock(world, pos, context.getItemInHand(), player, hand)) {
            this.playSound(world, pos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

