/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item.equipment;

import com.cmdpro.datanessence.entity.ThrownNaturalEssenceBombProjectile;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class NaturalEssenceBombItem
extends Item
implements ProjectileItem {
    public Projectile asProjectile(Level pLevel, Position pPos, ItemStack pStack, Direction pDirection) {
        return new ThrownNaturalEssenceBombProjectile(pLevel, pPos.x(), pPos.y(), pPos.z());
    }

    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().uncertainty(ProjectileItem.DispenseConfig.DEFAULT.uncertainty() * 0.5f).power(ProjectileItem.DispenseConfig.DEFAULT.power() * 1.25f).build();
    }

    public NaturalEssenceBombItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        pLevel.playSound((Player)null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), (SoundEvent)SoundRegistry.NATURAL_ESSENCE_BOMB_THROW.value(), SoundSource.PLAYERS, 0.5f, 0.4f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!pLevel.isClientSide) {
            ThrownNaturalEssenceBombProjectile bomb = new ThrownNaturalEssenceBombProjectile((LivingEntity)pPlayer, pLevel);
            bomb.setItem(itemstack);
            bomb.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), 0.0f, 1.5f, 1.0f);
            pLevel.addFreshEntity((Entity)bomb);
        }
        pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!pPlayer.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)pLevel.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        super.appendHoverText(stack, context, components, flag);
        components.add((Component)Component.translatable((String)"item.datanessence.natural_essence_bomb.info").withStyle(Style.EMPTY.withColor(EssenceTypeRegistry.NATURAL_ESSENCE.get().getColor())));
    }
}

