/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.networking;

import com.cmdpro.datanessence.networking.Message;
import com.cmdpro.datanessence.networking.packet.c2s.PlayerChangeDriveData;
import com.cmdpro.datanessence.networking.packet.c2s.PlayerFinishDataBankMinigame;
import com.cmdpro.datanessence.networking.packet.c2s.PlayerSetItemHandlerLocked;
import com.cmdpro.datanessence.networking.packet.c2s.RequestMachineEssenceValue;
import com.cmdpro.datanessence.networking.packet.s2c.AddScannedOre;
import com.cmdpro.datanessence.networking.packet.s2c.ComputerDataSync;
import com.cmdpro.datanessence.networking.packet.s2c.CreatePingShader;
import com.cmdpro.datanessence.networking.packet.s2c.DataBankEntrySync;
import com.cmdpro.datanessence.networking.packet.s2c.DragonPartsSync;
import com.cmdpro.datanessence.networking.packet.s2c.EntrySync;
import com.cmdpro.datanessence.networking.packet.s2c.GrapplingHookSync;
import com.cmdpro.datanessence.networking.packet.s2c.MachineEssenceValueSync;
import com.cmdpro.datanessence.networking.packet.s2c.OpenEntryEditor;
import com.cmdpro.datanessence.networking.packet.s2c.PingStructures;
import com.cmdpro.datanessence.networking.packet.s2c.PingableSync;
import com.cmdpro.datanessence.networking.packet.s2c.PlayerDataSync;
import com.cmdpro.datanessence.networking.packet.s2c.PlayerTierSync;
import com.cmdpro.datanessence.networking.packet.s2c.UnlockEntry;
import com.cmdpro.datanessence.networking.packet.s2c.UnlockedEntrySync;
import com.cmdpro.datanessence.networking.packet.s2c.vfx.PlayBufferTransferParticle;
import com.cmdpro.datanessence.networking.packet.s2c.vfx.PlayEnderPearlRedirectionEffect;
import com.cmdpro.datanessence.networking.packet.s2c.vfx.PlayGenderfluidTransitionEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="datanessence", bus=EventBusSubscriber.Bus.MOD)
public class ModMessages {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("datanessence").versioned("1.0");
        registrar.playToClient(UnlockEntry.TYPE, ModMessages.getNetworkCodec(UnlockEntry::read, UnlockEntry::write), Handler::handle);
        registrar.playToClient(UnlockedEntrySync.TYPE, ModMessages.getNetworkCodec(UnlockedEntrySync::read, UnlockedEntrySync::write), Handler::handle);
        registrar.playToClient(PlayerTierSync.TYPE, ModMessages.getNetworkCodec(PlayerTierSync::read, PlayerTierSync::write), Handler::handle);
        registrar.playToClient(PlayerDataSync.TYPE, ModMessages.getNetworkCodec(PlayerDataSync::read, PlayerDataSync::write), Handler::handle);
        registrar.playToClient(DataBankEntrySync.TYPE, ModMessages.getNetworkCodec(DataBankEntrySync::read, DataBankEntrySync::write), Handler::handle);
        registrar.playToClient(ComputerDataSync.TYPE, ModMessages.getNetworkCodec(ComputerDataSync::read, ComputerDataSync::write), Handler::handle);
        registrar.playToClient(EntrySync.TYPE, ModMessages.getNetworkCodec(EntrySync::read, EntrySync::write), Handler::handle);
        registrar.playToClient(DragonPartsSync.TYPE, ModMessages.getNetworkCodec(DragonPartsSync::read, DragonPartsSync::write), Handler::handle);
        registrar.playToClient(PlayBufferTransferParticle.TYPE, ModMessages.getNetworkCodec(PlayBufferTransferParticle::read, PlayBufferTransferParticle::write), Handler::handle);
        registrar.playToClient(PingStructures.TYPE, ModMessages.getNetworkCodec(PingStructures::read, PingStructures::write), Handler::handle);
        registrar.playToClient(PingableSync.TYPE, ModMessages.getNetworkCodec(PingableSync::read, PingableSync::write), Handler::handle);
        registrar.playToClient(CreatePingShader.TYPE, ModMessages.getNetworkCodec(CreatePingShader::read, CreatePingShader::write), Handler::handle);
        registrar.playToClient(GrapplingHookSync.TYPE, ModMessages.getNetworkCodec(GrapplingHookSync::read, GrapplingHookSync::write), Handler::handle);
        registrar.playToClient(PlayGenderfluidTransitionEffect.TYPE, ModMessages.getNetworkCodec(PlayGenderfluidTransitionEffect::read, PlayGenderfluidTransitionEffect::write), Handler::handle);
        registrar.playToClient(PlayEnderPearlRedirectionEffect.TYPE, ModMessages.getNetworkCodec(PlayEnderPearlRedirectionEffect::read, PlayEnderPearlRedirectionEffect::write), Handler::handle);
        registrar.playToClient(MachineEssenceValueSync.TYPE, ModMessages.getNetworkCodec(MachineEssenceValueSync::read, MachineEssenceValueSync::write), Handler::handle);
        registrar.playToClient(AddScannedOre.TYPE, ModMessages.getNetworkCodec(AddScannedOre::read, AddScannedOre::write), Handler::handle);
        registrar.playToClient(OpenEntryEditor.TYPE, ModMessages.getNetworkCodec(OpenEntryEditor::read, OpenEntryEditor::write), Handler::handle);
        registrar.playToServer(PlayerFinishDataBankMinigame.TYPE, ModMessages.getNetworkCodec(PlayerFinishDataBankMinigame::read, PlayerFinishDataBankMinigame::write), Handler::handle);
        registrar.playToServer(PlayerChangeDriveData.TYPE, ModMessages.getNetworkCodec(PlayerChangeDriveData::read, PlayerChangeDriveData::write), Handler::handle);
        registrar.playToServer(PlayerSetItemHandlerLocked.TYPE, ModMessages.getNetworkCodec(PlayerSetItemHandlerLocked::read, PlayerSetItemHandlerLocked::write), Handler::handle);
        registrar.playToServer(RequestMachineEssenceValue.TYPE, ModMessages.getNetworkCodec(RequestMachineEssenceValue::read, RequestMachineEssenceValue::write), Handler::handle);
    }

    public static <T extends Message> StreamCodec<RegistryFriendlyByteBuf, T> getNetworkCodec(Handler.Reader<T> reader, Handler.Writer<T> writer) {
        return StreamCodec.of(writer::write, reader::read);
    }

    public static <T extends Message> void sendToServer(T message) {
        PacketDistributor.sendToServer(message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends Message> void sendToPlayer(T message, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends Message> void sendToPlayersNear(T message, ServerLevel level, Vec3 position, float radius) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)position.x, (double)position.y, (double)position.z, (double)radius, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends Message> void sendToPlayersTrackingEntityAndSelf(T message, ServerPlayer player) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public class Handler {
        public Handler(ModMessages this$0) {
        }

        public static <T extends CustomPacketPayload> void handle(T message, IPayloadContext ctx) {
            if (message instanceof Message) {
                Message msg = (Message)message;
                if (ctx.flow().getReceptionSide() == LogicalSide.SERVER) {
                    ctx.enqueueWork(() -> Server.handle(msg, ctx));
                } else {
                    ctx.enqueueWork(() -> Client.handle(msg, ctx));
                }
            }
        }

        public class Client {
            public Client(Handler this$1) {
            }

            public static <T extends Message> void handle(T message, IPayloadContext ctx) {
                message.handleClient(Minecraft.getInstance(), (Player)Minecraft.getInstance().player, ctx);
            }
        }

        public class Server {
            public Server(Handler this$1) {
            }

            public static <T extends Message> void handle(T message, IPayloadContext ctx) {
                message.handleServer(ctx.player().getServer(), (ServerPlayer)ctx.player(), ctx);
            }
        }

        public static interface Writer<T extends Message> {
            public void write(RegistryFriendlyByteBuf var1, T var2);
        }

        public static interface Reader<T extends Message> {
            public T read(RegistryFriendlyByteBuf var1);
        }
    }
}

