/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.networking.packet.s2c;

import com.cmdpro.databank.shaders.PostShaderInstance;
import com.cmdpro.databank.shaders.PostShaderManager;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.client.shaders.PingShader;
import com.cmdpro.datanessence.config.DataNEssenceClientConfig;
import com.cmdpro.datanessence.networking.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CreatePingShader(Vec3 position) implements Message
{
    public static final CustomPacketPayload.Type<CreatePingShader> TYPE = new CustomPacketPayload.Type(DataNEssence.locate("create_ping_shader"));

    public static CreatePingShader read(RegistryFriendlyByteBuf buf) {
        Vec3 position = buf.readVec3();
        return new CreatePingShader(position);
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext ctx) {
        ClientHandler.startShader(this.position);
    }

    public static void write(RegistryFriendlyByteBuf buf, CreatePingShader obj) {
        buf.writeVec3(obj.position);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void startShader(Vec3 position) {
            if (DataNEssenceClientConfig.pingShader) {
                PingShader shader = new PingShader(position.toVector3f());
                shader.setActive(true);
                PostShaderManager.addShader((PostShaderInstance)shader);
            }
        }
    }
}

