/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.networking.packet.s2c;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.data.datatablet.DataTab;
import com.cmdpro.datanessence.data.datatablet.DataTabSerializer;
import com.cmdpro.datanessence.data.datatablet.Entries;
import com.cmdpro.datanessence.data.datatablet.Entry;
import com.cmdpro.datanessence.data.datatablet.EntrySerializer;
import com.cmdpro.datanessence.networking.Message;
import com.cmdpro.datanessence.screen.DataTabletScreen;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EntrySync(Map<ResourceLocation, Entry> entries, List<ResourceLocation> sortedEntries, Map<ResourceLocation, DataTab> tabs) implements Message
{
    public static final CustomPacketPayload.Type<EntrySync> TYPE = new CustomPacketPayload.Type(DataNEssence.locate("entry_sync"));

    public static EntrySync read(FriendlyByteBuf buf) {
        Map entries = buf.readMap((StreamDecoder)ResourceLocation.STREAM_CODEC, pBuffer -> (Entry)EntrySerializer.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)pBuffer)));
        List sortedEntries = buf.readList((StreamDecoder)ResourceLocation.STREAM_CODEC);
        Map tabs = buf.readMap((StreamDecoder)ResourceLocation.STREAM_CODEC, pBuffer -> (DataTab)DataTabSerializer.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)pBuffer)));
        return new EntrySync(entries, sortedEntries, tabs);
    }

    public static void write(RegistryFriendlyByteBuf buf, EntrySync obj) {
        buf.writeMap(obj.entries, (StreamEncoder)ResourceLocation.STREAM_CODEC, (pBuffer, pValue) -> EntrySerializer.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)pBuffer), pValue));
        buf.writeCollection(obj.sortedEntries, (StreamEncoder)ResourceLocation.STREAM_CODEC);
        buf.writeMap(obj.tabs, (StreamEncoder)ResourceLocation.STREAM_CODEC, (pBuffer, pValue) -> DataTabSerializer.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)pBuffer), pValue));
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext ctx) {
        ClientHandler.handle(this);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void handle(EntrySync packet) {
            Entries.entries.clear();
            Entries.entries.putAll(packet.entries);
            Entries.tabs.clear();
            Entries.tabs.putAll(packet.tabs);
            for (Entry entry : Entries.entries.values()) {
                entry.updateParentEntries();
            }
            Entries.tabsSorted.clear();
            for (ResourceLocation resourceLocation : packet.sortedEntries) {
                DataTab tab = Entries.tabs.get(resourceLocation);
                if (tab == null) continue;
                Entries.tabsSorted.add(tab);
            }
            DataTabletScreen.savedEntry = null;
        }
    }
}

