/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.networking.packet.s2c;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.item.equipment.EssenceMeter;
import com.cmdpro.datanessence.networking.Message;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MachineEssenceValueSync(BlockPos pos, Map<EssenceType, Float> values, float maxValue) implements Message
{
    public static final CustomPacketPayload.Type<MachineEssenceValueSync> TYPE = new CustomPacketPayload.Type(DataNEssence.locate("machine_essence_value_sync"));

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext ctx) {
        EssenceMeter.currentMachineEssenceValue = new MachineEssenceValue(this.pos, this.values, this.maxValue);
    }

    public static void write(RegistryFriendlyByteBuf pBuffer, MachineEssenceValueSync obj) {
        pBuffer.writeBlockPos(obj.pos);
        pBuffer.writeMap(obj.values, (buf, type) -> buf.writeResourceKey((ResourceKey)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getResourceKey(type).orElseThrow()), FriendlyByteBuf::writeFloat);
        pBuffer.writeFloat(obj.maxValue);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static MachineEssenceValueSync read(RegistryFriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        Map values = buf.readMap(buf2 -> {
            ResourceKey essenceType = buf2.readResourceKey(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY_KEY);
            return (EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get(essenceType);
        }, FriendlyByteBuf::readFloat);
        float maxValue = buf.readFloat();
        return new MachineEssenceValueSync(pos, values, maxValue);
    }

    public static MachineEssenceValueSync create(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EssenceBlockEntity) {
            EssenceBlockEntity essenceBlockEntity = (EssenceBlockEntity)blockEntity;
            HashMap<EssenceType, Float> values = new HashMap<EssenceType, Float>();
            for (EssenceType i : essenceBlockEntity.getStorage().getSupportedEssenceTypes()) {
                values.put(i, Float.valueOf(essenceBlockEntity.getStorage().getEssence(i)));
            }
            return new MachineEssenceValueSync(pos, values, essenceBlockEntity.getStorage().getMaxEssence());
        }
        return null;
    }

    public static class MachineEssenceValue {
        public BlockPos pos;
        public Map<EssenceType, Float> values;
        public float maxValue;

        public MachineEssenceValue(BlockPos pos, Map<EssenceType, Float> values, float maxValue) {
            this.pos = pos;
            this.values = values;
            this.maxValue = maxValue;
        }
    }
}

