/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.networking.packet.s2c;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.client.gui.PingsGuiLayer;
import com.cmdpro.datanessence.data.pinging.StructurePing;
import com.cmdpro.datanessence.networking.Message;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PingStructures(List<StructurePing> structures) implements Message
{
    public static final CustomPacketPayload.Type<PingStructures> TYPE = new CustomPacketPayload.Type(DataNEssence.locate("ping_structures"));

    public static PingStructures read(RegistryFriendlyByteBuf buf) {
        List structures = buf.readList(pBuffer -> (StructurePing)StructurePing.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)pBuffer)));
        return new PingStructures(structures);
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext ctx) {
        ClientHandler.addPings(this.structures);
    }

    public static void write(RegistryFriendlyByteBuf buf, PingStructures obj) {
        buf.writeCollection(obj.structures, (pBuffer, pValue) -> StructurePing.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)pBuffer), pValue));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void addPings(List<StructurePing> pings) {
            for (StructurePing i : pings) {
                PingsGuiLayer.pings.put(i, 200);
            }
        }
    }
}

