/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.networking.packet.s2c;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.data.pinging.PingableStructure;
import com.cmdpro.datanessence.data.pinging.PingableStructureManager;
import com.cmdpro.datanessence.data.pinging.PingableStructureSerializer;
import com.cmdpro.datanessence.networking.Message;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PingableSync(Map<ResourceLocation, PingableStructure> structures) implements Message
{
    public static final CustomPacketPayload.Type<PingableSync> TYPE = new CustomPacketPayload.Type(DataNEssence.locate("pingable_sync"));

    public static PingableSync read(FriendlyByteBuf buf) {
        Map structures = buf.readMap((StreamDecoder)ResourceLocation.STREAM_CODEC, pBuffer -> (PingableStructure)PingableStructureSerializer.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)pBuffer)));
        return new PingableSync(structures);
    }

    public static void write(RegistryFriendlyByteBuf buf, PingableSync obj) {
        buf.writeMap(obj.structures, (StreamEncoder)ResourceLocation.STREAM_CODEC, (pBuffer, pValue) -> PingableStructureSerializer.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)pBuffer), pValue));
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext ctx) {
        ClientHandler.handle(this);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void handle(PingableSync packet) {
            PingableStructureManager.types.clear();
            PingableStructureManager.types.putAll(packet.structures);
        }
    }
}

