/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.networking.packet.s2c.vfx;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.client.particle.MoteParticleOptions;
import com.cmdpro.datanessence.networking.Message;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PlayBufferTransferParticle(BlockPos pos, Color color) implements Message
{
    public static final CustomPacketPayload.Type<PlayBufferTransferParticle> TYPE = new CustomPacketPayload.Type(DataNEssence.locate("play_buffer_transfer_particle"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void write(RegistryFriendlyByteBuf buf, PlayBufferTransferParticle obj) {
        buf.writeBlockPos(obj.pos);
        buf.writeInt(obj.color.getRGB());
    }

    public static PlayBufferTransferParticle read(RegistryFriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        Color color = new Color(buf.readInt());
        return new PlayBufferTransferParticle(pos, color);
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext ctx) {
        Level world = player.level();
        RandomSource random = world.getRandom();
        double d0 = 0.5625;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = this.pos.relative(direction);
            if (world.getBlockState(blockpos).isSolidRender((BlockGetter)world, blockpos) || direction == Direction.UP || direction == Direction.DOWN) continue;
            Direction.Axis direction$axis = direction.getAxis();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.getStepX() : (double)random.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.getStepY() : (double)random.nextFloat();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.getStepZ() : (double)random.nextFloat();
            world.addParticle((ParticleOptions)new MoteParticleOptions().setColor(this.color).setAdditive(true).setLifetime(20), (double)this.pos.getX() + d1, (double)this.pos.getY() + d2 / 2.0, (double)this.pos.getZ() + d3, 0.0, 0.1, 0.0);
        }
    }
}

