/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.networking.packet.s2c.vfx;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.client.particle.ConfigurableParticleOptions;
import com.cmdpro.datanessence.client.particle.MoteParticleOptions;
import com.cmdpro.datanessence.client.particle.RhombusParticleOptions;
import com.cmdpro.datanessence.client.particle.SmallCircleParticleOptions;
import com.cmdpro.datanessence.networking.Message;
import com.cmdpro.datanessence.registry.SoundRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PlayGenderfluidTransitionEffect(BlockPos pos, Vec3 itemPos) implements Message
{
    public static final CustomPacketPayload.Type<PlayGenderfluidTransitionEffect> TYPE = new CustomPacketPayload.Type(DataNEssence.locate("play_genderfluid_transition_effect"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void write(RegistryFriendlyByteBuf buf, PlayGenderfluidTransitionEffect obj) {
        buf.writeBlockPos(obj.pos);
        buf.writeVec3(obj.itemPos);
    }

    public static PlayGenderfluidTransitionEffect read(RegistryFriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        Vec3 itemPos = buf.readVec3();
        return new PlayGenderfluidTransitionEffect(pos, itemPos);
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext ctx) {
        int i;
        Level level = player.level();
        RandomSource random = level.getRandom();
        float speedMult = 0.75f;
        player.level().playSound(player, this.pos, (SoundEvent)SoundRegistry.GENDERFLUID_TRANSITION.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        Vec3 pos = new Vec3(this.itemPos.x, this.pos.getCenter().add((double)0.0, (double)0.5, (double)0.0).y, this.itemPos.z);
        for (i = 0; i < 10; ++i) {
            level.addParticle((ParticleOptions)new RhombusParticleOptions().setColor(new Color(-9784324)).setAdditive(true), pos.x, pos.y, pos.z, (double)Mth.nextFloat((RandomSource)random, (float)(-speedMult), (float)speedMult), (double)Mth.nextFloat((RandomSource)random, (float)(-speedMult), (float)speedMult), (double)Mth.nextFloat((RandomSource)random, (float)(-speedMult), (float)speedMult));
            level.addParticle((ParticleOptions)new MoteParticleOptions().setColor(new Color(-1)).setAdditive(true), pos.x, pos.y, pos.z, (double)Mth.nextFloat((RandomSource)random, (float)(-speedMult), (float)speedMult), (double)Mth.nextFloat((RandomSource)random, (float)(-speedMult), (float)speedMult), (double)Mth.nextFloat((RandomSource)random, (float)(-speedMult), (float)speedMult));
            level.addParticle((ParticleOptions)new SmallCircleParticleOptions().setColor(new Color(-224581)).setAdditive(true), pos.x, pos.y, pos.z, (double)Mth.nextFloat((RandomSource)random, (float)(-speedMult), (float)speedMult), (double)Mth.nextFloat((RandomSource)random, (float)(-speedMult), (float)speedMult), (double)Mth.nextFloat((RandomSource)random, (float)(-speedMult), (float)speedMult));
        }
        for (i = 0; i < 16; ++i) {
            Vec2 dir = new Vec2((float)Math.sin(Math.toRadians((float)i * 22.5f)), (float)Math.cos(Math.toRadians((float)i * 22.5f)));
            List particles = new ArrayList<ConfigurableParticleOptions>();
            particles.add(new RhombusParticleOptions().setColor(new Color(-9784324)).setAdditive(true));
            particles.add(new MoteParticleOptions().setColor(new Color(-1)).setAdditive(true));
            particles.add(new SmallCircleParticleOptions().setColor(new Color(-224581)).setAdditive(true));
            particles = Util.shuffledCopy((Object[])particles.toArray(new ParticleOptions[0]), (RandomSource)random);
            speedMult = 1.0f;
            level.addParticle((ParticleOptions)particles.get(0), pos.x, pos.y, pos.z, (double)(dir.x * speedMult), 0.0, (double)(dir.y * speedMult));
            level.addParticle((ParticleOptions)particles.get(1), pos.x, pos.y, pos.z, (double)(dir.x * (speedMult /= 2.0f)), 0.0, (double)(dir.y * speedMult));
            level.addParticle((ParticleOptions)particles.get(2), pos.x, pos.y, pos.z, (double)(dir.x * (speedMult /= 2.0f)), 0.0, (double)(dir.y * speedMult));
        }
    }
}

