/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.recipe;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.recipe.DataNEssenceRecipe;
import com.cmdpro.datanessence.recipe.IHasRequiredKnowledge;
import com.cmdpro.datanessence.recipe.RecipeInputWithFluid;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidMixingRecipe
implements Recipe<RecipeInputWithFluid>,
IHasRequiredKnowledge,
DataNEssenceRecipe {
    private final FluidStack output;
    private final FluidStack input;
    private final Optional<FluidStack> input2;
    private final Optional<Ingredient> input3;
    private final int time;
    private final float essenceCost;
    private final ResourceLocation entry;
    private final int completionStage;

    public FluidMixingRecipe(FluidStack output, FluidStack input, Optional<FluidStack> input2, Optional<Ingredient> input3, int time, float essenceCost, ResourceLocation entry, int completionStage) {
        this.output = output;
        this.input = input;
        this.input2 = input2;
        this.input3 = input3;
        this.time = time;
        this.essenceCost = essenceCost;
        this.entry = entry;
        this.completionStage = completionStage;
    }

    @Override
    public int getCompletionStage() {
        return this.completionStage;
    }

    public float getEssenceCost() {
        return this.essenceCost;
    }

    public int getTime() {
        return this.time;
    }

    public FluidStack getInput1() {
        return this.input;
    }

    public FluidStack getInput2() {
        return this.input2.orElse(FluidStack.EMPTY);
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        this.input3.ifPresent(arg_0 -> list.add(arg_0));
        return list;
    }

    public boolean matches(RecipeInputWithFluid pContainer, Level pLevel) {
        if (FluidStack.isSameFluidSameComponents((FluidStack)this.input, (FluidStack)pContainer.getFluid(0)) && (this.input2.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)this.input2.get(), (FluidStack)pContainer.getFluid(1))) && (this.input3.isEmpty() || this.input3.get().test(pContainer.getItem(0)))) {
            return true;
        }
        return !(!FluidStack.isSameFluidSameComponents((FluidStack)this.input, (FluidStack)pContainer.getFluid(1)) || !this.input2.isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)this.input2.get(), (FluidStack)pContainer.getFluid(0)) || !this.input3.isEmpty() && !this.input3.get().test(pContainer.getItem(0)));
    }

    public ItemStack assemble(RecipeInputWithFluid pContainer, HolderLookup.Provider pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return RecipeRegistry.FLUID_MIXING_TYPE.get();
    }

    @Override
    public ResourceLocation getMachineEntry() {
        return DataNEssence.locate("machinery/fluid_mixer");
    }

    @Override
    public ResourceLocation getEntry() {
        return this.entry;
    }

    public static class Serializer
    implements RecipeSerializer<FluidMixingRecipe> {
        public static final MapCodec<FluidMixingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStack.CODEC.fieldOf("result").forGetter(r -> r.output), (App)FluidStack.CODEC.fieldOf("fluid_input").forGetter(r -> r.input), (App)FluidStack.CODEC.optionalFieldOf("fluid_input_2").forGetter(r -> r.input2), (App)Ingredient.CODEC.optionalFieldOf("item_input").forGetter(r -> r.input3), (App)Codec.INT.fieldOf("time").forGetter(r -> r.time), (App)Codec.FLOAT.optionalFieldOf("essenceCost", (Object)Float.valueOf(0.0f)).forGetter(r -> Float.valueOf(r.essenceCost)), (App)ResourceLocation.CODEC.fieldOf("entry").forGetter(r -> r.entry), (App)Codec.INT.optionalFieldOf("completion_stage", (Object)-1).forGetter(r -> r.completionStage)).apply((Applicative)instance, FluidMixingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidMixingRecipe> STREAM_CODEC = StreamCodec.of((buf, obj) -> {
            FluidStack.STREAM_CODEC.encode(buf, (Object)obj.output);
            FluidStack.STREAM_CODEC.encode(buf, (Object)obj.input);
            buf.writeBoolean(obj.input2.isPresent());
            obj.input2.ifPresent(fluidIngredient -> FluidStack.STREAM_CODEC.encode(buf, fluidIngredient));
            buf.writeBoolean(obj.input3.isPresent());
            obj.input3.ifPresent(ingredient -> Ingredient.CONTENTS_STREAM_CODEC.encode(buf, ingredient));
            buf.writeInt(obj.time);
            buf.writeFloat(obj.essenceCost);
            buf.writeResourceLocation(obj.entry);
            buf.writeInt(obj.completionStage);
        }, buf -> {
            FluidStack output = (FluidStack)FluidStack.STREAM_CODEC.decode(buf);
            FluidStack input = (FluidStack)FluidStack.STREAM_CODEC.decode(buf);
            boolean input2Exists = buf.readBoolean();
            Optional<FluidStack> input2 = Optional.empty();
            if (input2Exists) {
                input2 = Optional.of((FluidStack)FluidStack.STREAM_CODEC.decode(buf));
            }
            boolean input3Exists = buf.readBoolean();
            Optional<Ingredient> input3 = Optional.empty();
            if (input3Exists) {
                input3 = Optional.of((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf));
            }
            int time = buf.readInt();
            float essenceCost = buf.readFloat();
            ResourceLocation entry = buf.readResourceLocation();
            int completionStage = buf.readInt();
            return new FluidMixingRecipe(output, input, input2, input3, time, essenceCost, entry, completionStage);
        });
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<FluidMixingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FluidMixingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

