/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.recipe;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.recipe.DataNEssenceRecipe;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class MeltingRecipe
implements Recipe<RecipeInput>,
DataNEssenceRecipe {
    private final FluidStack output;
    private final Ingredient input;
    private final int time;

    public MeltingRecipe(FluidStack output, Ingredient input, int time) {
        this.output = output;
        this.input = input;
        this.time = time;
    }

    public int getTime() {
        return this.time;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.input);
        return list;
    }

    public boolean matches(RecipeInput pContainer, Level pLevel) {
        return this.input.test(pContainer.getItem(0));
    }

    public ItemStack assemble(RecipeInput pContainer, HolderLookup.Provider pRegistryAccess) {
        return ItemStack.EMPTY.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return RecipeRegistry.MELTING_TYPE.get();
    }

    @Override
    public ResourceLocation getMachineEntry() {
        return DataNEssence.locate("machinery/melter");
    }

    public static class Serializer
    implements RecipeSerializer<MeltingRecipe> {
        public static final MapCodec<MeltingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStack.CODEC.fieldOf("result").forGetter(r -> r.output), (App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.input), (App)Codec.INT.fieldOf("time").forGetter(r -> r.time)).apply((Applicative)instance, MeltingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MeltingRecipe> STREAM_CODEC = StreamCodec.of((buf, obj) -> {
            FluidStack.STREAM_CODEC.encode(buf, (Object)obj.output);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)obj.input);
            buf.writeInt(obj.time);
        }, buf -> {
            FluidStack output = (FluidStack)FluidStack.STREAM_CODEC.decode(buf);
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf);
            int time = buf.readInt();
            return new MeltingRecipe(output, input, time);
        });
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<MeltingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MeltingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

