/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.recipe;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.recipe.DataNEssenceRecipe;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class MineralPurificationRecipe
implements Recipe<RecipeInput>,
DataNEssenceRecipe {
    private final ItemStack output;
    private final ItemStack nuggetOutput;
    private final Ingredient input;
    private final int time;

    public MineralPurificationRecipe(ItemStack output, ItemStack nuggetOutput, Ingredient input, int time) {
        this.output = output;
        this.nuggetOutput = nuggetOutput;
        this.input = input;
        this.time = time;
    }

    public int getTime() {
        return this.time;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.input);
        return list;
    }

    public boolean matches(RecipeInput pContainer, Level pLevel) {
        return this.input.test(pContainer.getItem(0));
    }

    public ItemStack assemble(RecipeInput pContainer, HolderLookup.Provider pRegistryAccess) {
        return this.output.copy();
    }

    public ItemStack assembleNuggetOutput(RandomSource random, RecipeInput pContainer, HolderLookup.Provider pRegistryAccess) {
        ItemStack copy = this.nuggetOutput.copy();
        copy.setCount(copy.getCount() * random.nextInt(0, 9));
        return copy;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getNuggetOutput(HolderLookup.Provider pRegistryAccess) {
        return this.nuggetOutput;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistryAccess) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return RecipeRegistry.MINERAL_PURIFICATION_TYPE.get();
    }

    @Override
    public ResourceLocation getMachineEntry() {
        return DataNEssence.locate("machinery/mineral_purification_chamber");
    }

    public static class Serializer
    implements RecipeSerializer<MineralPurificationRecipe> {
        public static final MapCodec<MineralPurificationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.output), (App)ItemStack.CODEC.fieldOf("nuggetResult").forGetter(r -> r.nuggetOutput), (App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.input), (App)Codec.INT.fieldOf("time").forGetter(r -> r.time)).apply((Applicative)instance, MineralPurificationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MineralPurificationRecipe> STREAM_CODEC = StreamCodec.of((buf, obj) -> {
            ItemStack.STREAM_CODEC.encode(buf, (Object)obj.output);
            ItemStack.STREAM_CODEC.encode(buf, (Object)obj.nuggetOutput);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)obj.input);
            buf.writeInt(obj.time);
        }, buf -> {
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            ItemStack nuggetOutput = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf);
            int time = buf.readInt();
            return new MineralPurificationRecipe(output, nuggetOutput, input, time);
        });
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<MineralPurificationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MineralPurificationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

