/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.screen;

import com.cmdpro.databank.rendering.ColorUtil;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.SpecialConditionHandler;
import com.cmdpro.datanessence.api.datatablet.Page;
import com.cmdpro.datanessence.data.datatablet.DataTab;
import com.cmdpro.datanessence.data.datatablet.Entries;
import com.cmdpro.datanessence.data.datatablet.Entry;
import com.cmdpro.datanessence.moddata.ClientPlayerData;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Vector2i;

public class DataTabletScreen
extends Screen {
    public static final ResourceLocation TEXTURE_FRAME = DataNEssence.locate("textures/gui/data_tablet_frame.png");
    public static final ResourceLocation TEXTURE_MAIN = DataNEssence.locate("textures/gui/data_tablet.png");
    public static final ResourceLocation TEXTURE_PAGE = DataNEssence.locate("textures/gui/data_tablet_page.png");
    public static final ResourceLocation TEXTURE_CRAFTING = DataNEssence.locate("textures/gui/data_tablet_crafting.png");
    public static final ResourceLocation TEXTURE_CRAFTING2 = DataNEssence.locate("textures/gui/data_tablet_crafting2.png");
    public static final ResourceLocation TEXTURE_MISC = DataNEssence.locate("textures/gui/data_tablet_misc.png");
    public static int imageWidth = 256;
    public static int imageHeight = 166;
    public static ResourceLocation savedEntry;
    public static int savedPage;
    public double offsetX = imageWidth / 2;
    public double offsetY = imageHeight / 2;
    public int screenType;
    public Entry clickedEntry;
    public int page;
    public int ticks;
    public DataTab currentTab = this.getSortedTabs().get(0);
    public boolean scrolling;
    public int tabPage = 0;
    public double scrollbarPixels;
    public static float battery;

    public DataTabletScreen(Component pTitle) {
        super(pTitle);
        if (savedEntry != null) {
            for (Entry i : Entries.entries.values()) {
                if (!i.id.equals((Object)savedEntry)) continue;
                this.clickedEntry = i;
                this.screenType = 2;
                this.page = savedPage;
                break;
            }
        }
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.screenType == 2) {
            return this.clickedEntry.getPagesClient().get(this.page).onDrag(this, pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        if (pButton == 0 && (this.screenType == 0 || this.screenType == 1)) {
            this.offsetX += pDragX;
            this.offsetY += pDragY;
            return true;
        }
        return false;
    }

    public boolean clickEntry(Entry entry, int button) {
        if (button != 0) {
            return false;
        }
        return this.clickEntry(entry);
    }

    public boolean clickEntry(Entry entry) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.UI_CLICK.value()), (float)1.0f));
        this.screenType = 2;
        this.clickedEntry = entry;
        this.scrollbarPixels = 0.0;
        this.page = 0;
        return true;
    }

    public boolean clickTab(DataTab tab) {
        this.currentTab = tab;
        this.offsetX = imageWidth / 2;
        this.offsetY = imageHeight / 2;
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.UI_CLICK.value()), (float)1.0f));
        return true;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        if (this.screenType == 0) {
            if (pMouseX >= (double)x && pMouseY >= (double)y && pMouseX <= (double)(x + imageWidth) && pMouseY <= (double)(y + imageHeight)) {
                for (Entry entry : Entries.entries.values()) {
                    if (!entry.tab.equals((Object)this.currentTab.id) || !this.isEntryUnlocked(entry)) continue;
                    Vector2i entryPosition = this.getEntryPosition(entry);
                    if (!(pMouseX >= (double)(entryPosition.x * 20 - 10) + this.offsetX + (double)x) || !(pMouseX <= (double)(entryPosition.x * 20 + 10) + this.offsetX + (double)x) || !(pMouseY >= (double)(entryPosition.y * 20 - 10) + this.offsetY + (double)y) || !(pMouseY <= (double)(entryPosition.y * 20 + 10) + this.offsetY + (double)y)) continue;
                    return this.clickEntry(entry, pButton);
                }
            }
            if (pButton == 0) {
                int o = 0;
                for (DataTab tab : this.getCurrentTabs()) {
                    int x2 = x + (o >= 6 ? 255 : -21);
                    int y2 = y + 8 + o % 6 * 24;
                    if (pMouseX >= (double)x2 && pMouseY >= (double)y2 && pMouseX <= (double)(x2 + 21) && pMouseY <= (double)(y2 + 20)) {
                        return this.clickTab(tab);
                    }
                    ++o;
                }
                if (pMouseX >= (double)(x + imageWidth + 30) && pMouseX <= (double)(x + imageWidth + 42) && pMouseY >= (double)(y + (imageHeight / 2 - 20)) && pMouseY <= (double)(y + (imageHeight / 2 + 20)) && this.tabPage + 2 < this.getSortedTabs().size() / 6) {
                    ++this.tabPage;
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.UI_CLICK.value()), (float)1.0f));
                    return true;
                }
                if (pMouseX >= (double)(x - 42) && pMouseX <= (double)(x - 30) && pMouseY >= (double)(y + (imageHeight / 2 - 20)) && pMouseY <= (double)(y + (imageHeight / 2 + 20)) && this.tabPage > 0) {
                    --this.tabPage;
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.UI_CLICK.value()), (float)1.0f));
                    return true;
                }
            }
        }
        if (pButton == 1 && this.screenType == 2) {
            this.screenType = 0;
            return true;
        }
        if (pButton == 0 && this.screenType == 2) {
            if (!this.clickedEntry.getPagesClient().isEmpty()) {
                boolean scrollbarHovered;
                int scrollbarX = x + 247;
                int n2 = y + 10;
                n2 = (int)((double)n2 + this.scrollbarPixels);
                boolean bl = scrollbarHovered = pMouseX >= (double)scrollbarX && pMouseY >= (double)n2 && pMouseX <= (double)(scrollbarX + 3) && pMouseY <= (double)(n2 + 7);
                if (scrollbarHovered) {
                    this.scrolling = true;
                    return true;
                }
            }
            if (pMouseX >= (double)(x + imageWidth + 6) && pMouseX <= (double)(x + imageWidth + 18) && pMouseY >= (double)(y + (imageHeight / 2 - 20)) && pMouseY <= (double)(y + (imageHeight / 2 + 20)) && this.clickedEntry.getPagesClient().size() > this.page + 1) {
                this.scrollbarPixels = 0.0;
                ++this.page;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.UI_CLICK.value()), (float)1.0f));
                return true;
            }
            if (pMouseX >= (double)(x - 18) && pMouseX <= (double)(x - 6) && pMouseY >= (double)(y + (imageHeight / 2 - 20)) && pMouseY <= (double)(y + (imageHeight / 2 + 20)) && this.page > 0) {
                this.scrollbarPixels = 0.0;
                --this.page;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.UI_CLICK.value()), (float)1.0f));
                return true;
            }
            if (pMouseX >= (double)(x + 1) && pMouseX <= (double)(x + imageWidth - 1) && pMouseY >= (double)(y + 1) && pMouseY <= (double)(y + imageHeight - 1)) {
                return this.clickedEntry.getPagesClient().get(this.page).onClick(this, pMouseX, pMouseY, pButton, x, y);
            }
            if (pMouseX >= (double)(x + imageWidth) && pMouseX <= (double)(x + imageWidth + 17) && pMouseY >= (double)(y + 10) && pMouseY <= (double)(y + 10 + 21)) {
                if (Screen.hasShiftDown()) {
                    savedEntry = null;
                    savedPage = 0;
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.UI_CLICK.value()), (float)1.0f));
                } else {
                    savedEntry = this.clickedEntry.id;
                    savedPage = this.page;
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.UI_CLICK.value()), (float)1.0f));
                    super.onClose();
                }
                return true;
            }
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return false;
    }

    public void tick() {
        super.tick();
        ++this.ticks;
        if (this.canHaveBattery() && SpecialConditionHandler.isAprilFools() && (battery -= 0.01f * Math.clamp((float)0.0f, (float)1.0f, (float)(battery / 100.0f * 3.0f))) < 1.0f) {
            battery = 1.0f;
        }
    }

    public boolean canHaveBattery() {
        return true;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        if (this.scrolling && !this.clickedEntry.getPagesClient().isEmpty()) {
            int scrollbarY = y + 10;
            int scrollbarArea = 139;
            this.scrollbarPixels = Math.clamp((double)0.0, (double)scrollbarArea, (double)(mouseY - (double)scrollbarY));
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.screenType == 2 && !this.clickedEntry.getPagesClient().isEmpty()) {
            int scrollbarArea = 139;
            int scrollMax = Math.max((int)0, (int)(this.clickedEntry.getPagesClient().get(this.page).getMaxScrollY() - (imageHeight - 3)));
            double scrollSpeed = 20.0f / ((float)scrollMax / 50.0f);
            this.scrollbarPixels = Math.clamp((double)0.0, (double)scrollbarArea, (double)(this.scrollbarPixels - scrollY * scrollSpeed));
        }
        return false;
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        pGuiGraphics.blit(this.getTextureToUse(), x, y, 0, 0, imageWidth, imageHeight);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void onClose() {
        if (this.screenType != 2) {
            super.onClose();
        } else {
            this.screenType = 0;
        }
    }

    public ResourceLocation getTextureToUse() {
        if (this.screenType == 2) {
            return TEXTURE_PAGE;
        }
        return TEXTURE_MAIN;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        if (this.screenType == 0) {
            int o = 0;
            for (DataTab i : this.getCurrentTabs()) {
                int shift = 0;
                int x2 = x + (o >= 6 ? 255 : -21);
                int y2 = y + 8 + o % 6 * 24;
                if (mouseX >= x2 && mouseY >= y2 && mouseX <= x2 + 21 && mouseY <= y2 + 20) {
                    shift = 40;
                }
                graphics.blit(this.getTextureToUse(), x + (o >= 6 ? 256 : -21), y + 8 + o % 6 * 24, o >= 6 ? 66 : 87, 166 + shift, 21, 20);
                graphics.renderItem(i.icon, x + (o >= 6 ? 258 : -18), y + 8 + o % 6 * 24 + 2);
                ++o;
            }
        }
        this.renderBg(graphics, delta, mouseX, mouseY);
        graphics.enableScissor(x + 3, y + 3, x + imageWidth - 3, y + imageHeight - 3);
        if (this.screenType == 0) {
            this.drawEntries(graphics, delta, mouseX, mouseY);
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 399.0f);
            graphics.blit(this.getTextureToUse(), x + 3, y + 3, 48, 166, 4, 4);
            graphics.blit(this.getTextureToUse(), x + 3, y + imageHeight - 7, 48, 170, 4, 4);
            graphics.blit(this.getTextureToUse(), x + imageWidth - 7, y + 3, 52, 166, 4, 4);
            graphics.blit(this.getTextureToUse(), x + imageWidth - 7, y + imageHeight - 7, 52, 170, 4, 4);
            graphics.pose().popPose();
        } else if (this.screenType != 1 && this.screenType == 2 && !this.clickedEntry.getPagesClient().isEmpty()) {
            this.drawPage(this.clickedEntry.getPagesClient().get(this.page), graphics, delta, mouseX, mouseY);
        }
        graphics.disableScissor();
        if (this.screenType == 0) {
            int shift;
            Font font = Minecraft.getInstance().font;
            MutableComponent mutableComponent = Component.translatable((String)"data_tablet.tier", (Object[])new Object[]{ClientPlayerData.getTier()});
            int n = x + imageWidth / 2;
            Objects.requireNonNull(Minecraft.getInstance().font);
            graphics.drawCenteredString(font, (Component)mutableComponent, n, y - (9 + 4), -3601013);
            if (this.tabPage + 2 < this.getSortedTabs().size() / 6) {
                shift = 0;
                if (mouseX >= x + imageWidth + 6 && mouseX <= x + imageWidth + 18 && mouseY >= y + (imageHeight / 2 - 20) && mouseY <= y + (imageHeight / 2 + 20)) {
                    shift = 40;
                }
                graphics.blit(this.getTextureToUse(), x + imageWidth + 30, y + (imageHeight / 2 - 20), 32, 166 + shift, 12, 40);
            }
            if (this.tabPage > 0) {
                shift = 0;
                if (mouseX >= x - 18 && mouseX <= x - 6 && mouseY >= y + (imageHeight / 2 - 20) && mouseY <= y + (imageHeight / 2 + 20)) {
                    shift = 40;
                }
                graphics.blit(this.getTextureToUse(), x - 42, y + (imageHeight / 2 - 20), 20, 166, 12 + shift, 40);
            }
            List<FormattedCharSequence> tooltip = null;
            if (mouseX >= x && mouseY >= y && mouseX <= x + imageWidth && mouseY <= y + imageHeight) {
                for (Entry entry : Entries.entries.values()) {
                    if (!entry.tab.equals((Object)this.currentTab.id) || !this.isEntryUnlocked(entry)) continue;
                    Vector2i entryPosition = this.getEntryPosition(entry);
                    if (!((double)mouseX >= (double)(entryPosition.x * 20 - 10) + this.offsetX + (double)x) || !((double)mouseX <= (double)(entryPosition.x * 20 + 10) + this.offsetX + (double)x) || !((double)mouseY >= (double)(entryPosition.y * 20 - 10) + this.offsetY + (double)y) || !((double)mouseY <= (double)(entryPosition.y * 20 + 10) + this.offsetY + (double)y)) continue;
                    Component name = entry.getName(this.getEntryCompletionStage(entry));
                    Component flavor = entry.getFlavor(this.getEntryCompletionStage(entry));
                    if (entry.isIncomplete(this.getEntryCompletionStage(entry))) {
                        MutableComponent progressionRequirement = Component.translatable((String)"tooltip.datanessence.progression_requirement").copy().withStyle(ChatFormatting.ITALIC).withColor(-40502);
                        tooltip = flavor.equals((Object)Component.empty()) ? List.of(name.getVisualOrderText(), progressionRequirement.getVisualOrderText()) : List.of(name.getVisualOrderText(), flavor.copy().withStyle(ChatFormatting.ITALIC).withColor(EssenceTypeRegistry.ESSENCE.get().getColor()).getVisualOrderText(), progressionRequirement.getVisualOrderText());
                        break;
                    }
                    tooltip = flavor.equals((Object)Component.empty()) ? List.of(name.getVisualOrderText()) : List.of(name.getVisualOrderText(), flavor.copy().withStyle(ChatFormatting.ITALIC).withColor(EssenceTypeRegistry.ESSENCE.get().getColor()).getVisualOrderText());
                    break;
                }
            }
            int o = 0;
            for (DataTab i : this.getCurrentTabs()) {
                int x2 = x + (o >= 6 ? 255 : -21);
                int y2 = y + 8 + o % 6 * 24;
                if (mouseX >= x2 && mouseY >= y2 && mouseX <= x2 + 21 && mouseY <= y2 + 20) {
                    tooltip = List.of(i.name.getVisualOrderText());
                }
                ++o;
            }
            if (tooltip != null) {
                graphics.renderTooltip(Minecraft.getInstance().font, tooltip, mouseX, mouseY);
            }
        } else if (this.screenType == 2) {
            Font font = Minecraft.getInstance().font;
            Component component = this.clickedEntry.getName(this.getEntryCompletionStage(this.clickedEntry));
            int n = x + imageWidth / 2;
            Objects.requireNonNull(Minecraft.getInstance().font);
            graphics.drawCenteredString(font, component, n, y - (9 + 4), -3601013);
            if (mouseX >= x + imageWidth && mouseX <= x + imageWidth + 17 && mouseY >= y + 10 && mouseY <= y + 10 + 21) {
                MutableComponent tooltip = !Screen.hasShiftDown() ? Component.translatable((String)"tooltip.datanessence.save_and_exit") : Component.translatable((String)"tooltip.datanessence.save_and_exit_sneak");
                graphics.renderTooltip(Minecraft.getInstance().font, (Component)tooltip, mouseX, mouseY);
                graphics.blit(TEXTURE_MISC, x + imageWidth, y + 10, 38, 21, 17, 21);
            } else {
                graphics.blit(TEXTURE_MISC, x + imageWidth, y + 10, 38, 0, 17, 21);
            }
        }
        if (SpecialConditionHandler.isAprilFools()) {
            graphics.blit(TEXTURE_MISC, x + 5, y + 5, 16, 38, 17, 8);
            int batteryWidth = 11;
            if (battery <= 99.0f) {
                batteryWidth = 8;
            }
            if (battery <= 66.666664f) {
                batteryWidth = 5;
            }
            if (battery <= 33.333332f) {
                batteryWidth = 2;
            }
            graphics.blit(TEXTURE_MISC, x + 8, y + 7, 16, 46, batteryWidth, 8);
            graphics.drawString(Minecraft.getInstance().font, (int)Math.ceil((float)battery) + "%", x + 24, y + 5, 16750261);
        }
    }

    public void drawPage(Page page, GuiGraphics graphics, float pPartialTick, int mouseX, int mouseY) {
        int shift;
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        int scrollbarArea = 139;
        int scrollMax = Math.max((int)0, (int)(page.getMaxScrollY() - (imageHeight - 3)));
        int scrollShift = (int)((float)this.scrollbarPixels / (float)scrollbarArea * (float)scrollMax);
        page.render(this, graphics, pPartialTick, mouseX, mouseY, x, y - scrollShift);
        graphics.disableScissor();
        if (scrollMax > 0) {
            graphics.blit(TEXTURE_PAGE, x + 246, y + 7, 25, 166, 5, 5);
            for (int i = 0; i < 142; ++i) {
                graphics.blit(TEXTURE_PAGE, x + 246, y + 12 + i, 25, 171, 5, 1);
            }
            graphics.blit(TEXTURE_PAGE, x + 246, y + 154, 25, 184, 5, 5);
            int scrollbarX = x + 247;
            int scrollbarY = y + 10;
            scrollbarY = (int)((double)scrollbarY + this.scrollbarPixels);
            boolean scrollbarHovered = mouseX >= scrollbarX && mouseY >= scrollbarY && mouseX <= scrollbarX + 3 && mouseY <= scrollbarY + 7;
            graphics.blit(TEXTURE_PAGE, scrollbarX, scrollbarY, 31, scrollbarHovered || this.scrolling ? 177 : 170, 3, 7);
        }
        if (this.page + 1 < this.clickedEntry.getPagesClient().size()) {
            shift = 0;
            if (mouseX >= x + imageWidth + 6 && mouseX <= x + imageWidth + 18 && mouseY >= y + (imageHeight / 2 - 20) && mouseY <= y + (imageHeight / 2 + 20)) {
                shift = 40;
            }
            graphics.blit(this.getTextureToUse(), x + imageWidth + 6, y + (imageHeight / 2 - 20), 12, 166 + shift, 12, 40);
        }
        if (this.page > 0) {
            shift = 0;
            if (mouseX >= x - 18 && mouseX <= x - 6 && mouseY >= y + (imageHeight / 2 - 20) && mouseY <= y + (imageHeight / 2 + 20)) {
                shift = 40;
            }
            graphics.blit(this.getTextureToUse(), x - 18, y + (imageHeight / 2 - 20), 0, 166 + shift, 12, 40);
        }
        page.renderPost(this, graphics, pPartialTick, mouseX, mouseY, x, y);
        graphics.enableScissor(x + 1, y + 1, x + imageWidth - 1, y + imageHeight - 1);
    }

    public void drawLines(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        for (Entry destinationEntry : Entries.entries.values()) {
            if (!destinationEntry.tab.equals((Object)this.currentTab.id) || !this.isEntryUnlocked(destinationEntry)) continue;
            for (Entry sourceEntry : this.getEntryParentEntries(destinationEntry)) {
                if (!sourceEntry.tab.equals((Object)this.currentTab.id)) continue;
                Vector2i entry1Pos = this.getEntryPosition(destinationEntry);
                Vector2i entry2Pos = this.getEntryPosition(sourceEntry);
                int sourceX = x + entry1Pos.x * 20 + (int)this.offsetX;
                int sourceY = y + entry1Pos.y * 20 + (int)this.offsetY;
                int destinationX = x + entry2Pos.x * 20 + (int)this.offsetX;
                int destinationY = y + entry2Pos.y * 20 + (int)this.offsetY;
                this.drawLine(sourceX, sourceY, destinationX, destinationY, sourceEntry, destinationEntry, pPartialTick, pMouseX, pMouseY);
            }
        }
    }

    public void drawLine(int sourceX, int sourceY, int destinationX, int destinationY, Entry sourceEntry, Entry destinationEntry, float partialTick, int mouseX, int mouseY) {
        long time = System.currentTimeMillis() / 50L;
        Vec3 origin = new Vec3((double)sourceX, (double)sourceY, 0.0);
        Vec3 line = new Vec3(origin.x - (double)destinationX, origin.y - (double)destinationY, 0.0);
        int lineSegments = (int)Math.ceil((double)(line.length() / 1.0));
        if (lineSegments > 0) {
            Tesselator tess = RenderSystem.renderThreadTesselator();
            RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
            RenderSystem.lineWidth((float)(2.0f * (float)Minecraft.getInstance().getWindow().getGuiScale()));
            GlStateManager._depthMask((boolean)false);
            GlStateManager._disableCull();
            int activeSegment = (int)(time % (long)lineSegments);
            Vec3 segmentIteration = new Vec3(line.x / (double)lineSegments, line.y / (double)lineSegments, line.z / (double)lineSegments);
            for (int i = lineSegments; i >= 0; --i) {
                double lx = origin.x();
                double ly = origin.y();
                origin = origin.subtract(segmentIteration);
                Vec2 normal = new Vec2((float)(origin.x - lx), (float)(origin.y - ly)).normalized();
                float blendSize = 8.0f;
                float blend = Math.clamp((float)0.0f, (float)1.0f, (float)((blendSize - Math.abs((float)((float)i - (float)activeSegment))) / blendSize));
                int color = ColorUtil.blendColors((Color)this.getLineColor1(sourceEntry, destinationEntry, partialTick, mouseX, mouseY), (Color)this.getLineColor2(sourceEntry, destinationEntry, partialTick, mouseX, mouseY), (float)blend).getRGB();
                BufferBuilder builder = tess.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
                builder.addVertex((float)lx, (float)ly, 0.0f).setColor(color).setNormal(normal.x, normal.y, 0.0f);
                builder.addVertex((float)origin.x, (float)origin.y, 0.0f).setColor(color).setNormal(normal.x, normal.y, 0.0f);
                BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            }
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        GlStateManager._enableCull();
        GlStateManager._depthMask((boolean)true);
        RenderSystem.lineWidth((float)1.0f);
    }

    public Color getLineColor1(Entry source, Entry destination, float pPartialTick, int pMouseX, int pMouseY) {
        return new Color(17, 20, 38, 255);
    }

    public Color getLineColor2(Entry source, Entry destination, float pPartialTick, int pMouseX, int pMouseY) {
        return new Color(70, 216, 252, 255);
    }

    public List<DataTab> getSortedTabs() {
        return Entries.tabsSorted;
    }

    public List<DataTab> getCurrentTabs() {
        ArrayList<DataTab> tabs = new ArrayList<DataTab>();
        List<DataTab> sorted = this.getSortedTabs();
        ArrayList<DataTab> visible = new ArrayList<DataTab>();
        block0: for (DataTab i : sorted.stream().toList()) {
            if (i.alwaysShown) {
                visible.add(i);
                continue;
            }
            for (Entry j : Entries.entries.values()) {
                if (!this.isEntryUnlocked(j) || !j.tab.equals((Object)i.id)) continue;
                visible.add(i);
                continue block0;
            }
        }
        for (int i = this.tabPage * 6; i < Math.min((int)visible.size(), (int)(this.tabPage * 6 + 12)); ++i) {
            tabs.add((DataTab)visible.get(i));
        }
        return tabs;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void drawEntries(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        this.drawLines(pGuiGraphics, pPartialTick, pMouseX, pMouseY);
        for (Entry i : Entries.entries.values()) {
            if (!i.tab.equals((Object)this.currentTab.id) || !this.isEntryUnlocked(i)) continue;
            Vector2i entryPosition = this.getEntryPosition(i);
            int entryShift = 0;
            int incompleteShift = 0;
            if (pMouseX >= x && pMouseY >= y && pMouseX <= x + imageWidth && pMouseY <= y + imageHeight && (double)pMouseX >= (double)(entryPosition.x * 20 - 10) + this.offsetX + (double)x && (double)pMouseX <= (double)(entryPosition.x * 20 + 10) + this.offsetX + (double)x && (double)pMouseY >= (double)(entryPosition.y * 20 - 10) + this.offsetY + (double)y && (double)pMouseY <= (double)(entryPosition.y * 20 + 10) + this.offsetY + (double)y) {
                entryShift = 40;
                incompleteShift = 10;
            }
            pGuiGraphics.blit(TEXTURE_MAIN, x + (entryPosition.x * 20 - 10) + (int)this.offsetX, y + (entryPosition.y * 20 - 10) + (int)this.offsetY, 0, 166 + entryShift, 20, 20);
            pGuiGraphics.renderItem(i.getIcon(this.getEntryCompletionStage(i)), x + (entryPosition.x * 20 - 8) + (int)this.offsetX, y + (entryPosition.y * 20 - 8) + (int)this.offsetY);
            if (!i.isIncomplete(this.getEntryCompletionStage(i))) continue;
            pGuiGraphics.blit(TEXTURE_MAIN, x + (entryPosition.x * 20 + 5) + (int)this.offsetX, y + (entryPosition.y * 20 + 5) + (int)this.offsetY, 0, 186 + incompleteShift, 11, 10);
        }
    }

    public Vector2i getEntryPosition(Entry entry) {
        return new Vector2i(entry.x, entry.y);
    }

    public boolean isEntryUnlocked(Entry entry) {
        return entry.isDefault || entry.isVisibleClient();
    }

    public int getEntryCompletionStage(Entry entry) {
        return entry.getIncompleteStageClient();
    }

    public List<Entry> getEntryParentEntries(Entry entry) {
        return entry.getParentEntries();
    }

    public List<ResourceLocation> getEntryParents(Entry entry) {
        return entry.parents;
    }

    static {
        battery = 100.0f;
    }
}

