/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.screen;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceBarBackgroundTypes;
import com.cmdpro.datanessence.api.util.client.ClientEssenceBarUtil;
import com.cmdpro.datanessence.moddata.ClientPlayerData;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.screen.EssenceBurnerMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class EssenceBurnerScreen
extends AbstractContainerScreen<EssenceBurnerMenu> {
    public static final ResourceLocation TEXTURE = DataNEssence.locate("textures/gui/essence_burner.png");

    public EssenceBurnerScreen(EssenceBurnerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((EssenceBurnerMenu)this.menu).blockEntity.burnTime > 0.0f) {
            pGuiGraphics.blit(TEXTURE, x + 81, y + 49 - (int)Math.ceil(13.0f * (((EssenceBurnerMenu)this.menu).blockEntity.burnTime / ((EssenceBurnerMenu)this.menu).blockEntity.maxBurnTime)), 177, 12 - (int)Math.ceil(13.0f * (((EssenceBurnerMenu)this.menu).blockEntity.burnTime / ((EssenceBurnerMenu)this.menu).blockEntity.maxBurnTime)), 13, (int)Math.ceil(13.0f * (((EssenceBurnerMenu)this.menu).blockEntity.burnTime / ((EssenceBurnerMenu)this.menu).blockEntity.maxBurnTime)));
        }
        ClientEssenceBarUtil.drawEssenceBar(pGuiGraphics, x + 8, y + 17, EssenceTypeRegistry.ESSENCE.get(), ((EssenceBurnerMenu)this.menu).blockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()), ((EssenceBurnerMenu)this.menu).blockEntity.getStorage().getMaxEssence(), EssenceBarBackgroundTypes.INDUSTRIAL);
        ClientEssenceBarUtil.drawEssenceBar(pGuiGraphics, x + 19, y + 17, EssenceTypeRegistry.LUNAR_ESSENCE.get(), ((EssenceBurnerMenu)this.menu).blockEntity.getStorage().getEssence(EssenceTypeRegistry.LUNAR_ESSENCE.get()), ((EssenceBurnerMenu)this.menu).blockEntity.getStorage().getMaxEssence(), EssenceBarBackgroundTypes.INDUSTRIAL);
        ClientEssenceBarUtil.drawEssenceBar(pGuiGraphics, x + 30, y + 17, EssenceTypeRegistry.NATURAL_ESSENCE.get(), ((EssenceBurnerMenu)this.menu).blockEntity.getStorage().getEssence(EssenceTypeRegistry.NATURAL_ESSENCE.get()), ((EssenceBurnerMenu)this.menu).blockEntity.getStorage().getMaxEssence(), EssenceBarBackgroundTypes.INDUSTRIAL);
        ClientEssenceBarUtil.drawEssenceBar(pGuiGraphics, x + 41, y + 17, EssenceTypeRegistry.EXOTIC_ESSENCE.get(), ((EssenceBurnerMenu)this.menu).blockEntity.getStorage().getEssence(EssenceTypeRegistry.EXOTIC_ESSENCE.get()), ((EssenceBurnerMenu)this.menu).blockEntity.getStorage().getMaxEssence(), EssenceBarBackgroundTypes.INDUSTRIAL);
        ClientEssenceBarUtil.drawEssenceIcon(pGuiGraphics, x + 7, y + 6, EssenceTypeRegistry.ESSENCE.get(), EssenceBarBackgroundTypes.INDUSTRIAL, ClientPlayerData.getUnlockedEssences().getOrDefault(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)EssenceTypeRegistry.ESSENCE.get()), false));
        ClientEssenceBarUtil.drawEssenceIcon(pGuiGraphics, x + 18, y + 6, EssenceTypeRegistry.LUNAR_ESSENCE.get(), EssenceBarBackgroundTypes.INDUSTRIAL, ClientPlayerData.getUnlockedEssences().getOrDefault(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)EssenceTypeRegistry.LUNAR_ESSENCE.get()), false));
        ClientEssenceBarUtil.drawEssenceIcon(pGuiGraphics, x + 29, y + 6, EssenceTypeRegistry.NATURAL_ESSENCE.get(), EssenceBarBackgroundTypes.INDUSTRIAL, ClientPlayerData.getUnlockedEssences().getOrDefault(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)EssenceTypeRegistry.NATURAL_ESSENCE.get()), false));
        ClientEssenceBarUtil.drawEssenceIcon(pGuiGraphics, x + 40, y + 6, EssenceTypeRegistry.EXOTIC_ESSENCE.get(), EssenceBarBackgroundTypes.INDUSTRIAL, ClientPlayerData.getUnlockedEssences().getOrDefault(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)EssenceTypeRegistry.EXOTIC_ESSENCE.get()), false));
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Component exoticEssence;
        Component naturalEssence;
        Component lunarEssence;
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        ArrayList<FormattedCharSequence> component = new ArrayList<FormattedCharSequence>();
        Component essence = ClientEssenceBarUtil.getEssenceBarTooltip(pMouseX, pMouseY, x + 8, y + 17, EssenceTypeRegistry.ESSENCE.get(), ((EssenceBurnerMenu)this.menu).blockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()));
        if (essence != null) {
            component.clear();
            component.add(essence.getVisualOrderText());
        }
        if ((lunarEssence = ClientEssenceBarUtil.getEssenceBarTooltip(pMouseX, pMouseY, x + 19, y + 17, EssenceTypeRegistry.LUNAR_ESSENCE.get(), ((EssenceBurnerMenu)this.menu).blockEntity.getStorage().getEssence(EssenceTypeRegistry.LUNAR_ESSENCE.get()))) != null) {
            component.clear();
            component.add(lunarEssence.getVisualOrderText());
        }
        if ((naturalEssence = ClientEssenceBarUtil.getEssenceBarTooltip(pMouseX, pMouseY, x + 30, y + 17, EssenceTypeRegistry.NATURAL_ESSENCE.get(), ((EssenceBurnerMenu)this.menu).blockEntity.getStorage().getEssence(EssenceTypeRegistry.NATURAL_ESSENCE.get()))) != null) {
            component.clear();
            component.add(naturalEssence.getVisualOrderText());
        }
        if ((exoticEssence = ClientEssenceBarUtil.getEssenceBarTooltip(pMouseX, pMouseY, x + 41, y + 17, EssenceTypeRegistry.EXOTIC_ESSENCE.get(), ((EssenceBurnerMenu)this.menu).blockEntity.getStorage().getEssence(EssenceTypeRegistry.EXOTIC_ESSENCE.get()))) != null) {
            component.clear();
            component.add(exoticEssence.getVisualOrderText());
        }
        if (component != null) {
            pGuiGraphics.renderTooltip(this.font, component, pMouseX, pMouseY);
        }
    }
}

