/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.screen;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceBarBackgroundTypes;
import com.cmdpro.datanessence.api.util.client.ClientEssenceBarUtil;
import com.cmdpro.datanessence.moddata.ClientPlayerData;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.screen.FluidMixerMenu;
import com.cmdpro.datanessence.screen.widget.FluidWidget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class FluidMixerScreen
extends AbstractContainerScreen<FluidMixerMenu> {
    public static final ResourceLocation TEXTURE = DataNEssence.locate("textures/gui/fluid_mixer.png");

    public FluidMixerScreen(FluidMixerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.addRenderableWidget((GuiEventListener)new FluidWidget(x + 39, y + 22, ((FluidMixerMenu)this.menu).blockEntity.getFluidHandler(), 0, false));
        this.addRenderableWidget((GuiEventListener)new FluidWidget(x + 39, y + 45, ((FluidMixerMenu)this.menu).blockEntity.getFluidHandler(), 1, false));
        this.addRenderableWidget((GuiEventListener)new FluidWidget(x + 116, y + 34, ((FluidMixerMenu)this.menu).blockEntity.getOutputHandler(), 0, false));
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((FluidMixerMenu)this.menu).blockEntity.maxWorkTime >= 0) {
            pGuiGraphics.blit(TEXTURE, x + 82, y + 33, 177, 0, (int)Math.ceil(22.0f * ((float)((FluidMixerMenu)this.menu).blockEntity.workTime / (float)((FluidMixerMenu)this.menu).blockEntity.maxWorkTime)), 17);
        }
        ClientEssenceBarUtil.drawEssenceBar(pGuiGraphics, x + 8, y + 17, EssenceTypeRegistry.ESSENCE.get(), ((FluidMixerMenu)this.menu).blockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()), ((FluidMixerMenu)this.menu).blockEntity.getStorage().getMaxEssence(), EssenceBarBackgroundTypes.INDUSTRIAL);
        ClientEssenceBarUtil.drawEssenceIcon(pGuiGraphics, x + 7, y + 6, EssenceTypeRegistry.ESSENCE.get(), EssenceBarBackgroundTypes.INDUSTRIAL, ClientPlayerData.getUnlockedEssences().getOrDefault(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)EssenceTypeRegistry.ESSENCE.get()), false));
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        ArrayList<FormattedCharSequence> component = new ArrayList<FormattedCharSequence>();
        Component essence = ClientEssenceBarUtil.getEssenceBarTooltip(pMouseX, pMouseY, x + 8, y + 17, EssenceTypeRegistry.ESSENCE.get(), ((FluidMixerMenu)this.menu).blockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()));
        if (essence != null) {
            component.clear();
            component.add(essence.getVisualOrderText());
        }
        if (component != null) {
            pGuiGraphics.renderTooltip(this.font, component, pMouseX, pMouseY);
        }
    }
}

