/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.screen.dev;

import com.cmdpro.databank.rendering.ColorUtil;
import com.cmdpro.datanessence.data.datatablet.Entries;
import com.cmdpro.datanessence.data.datatablet.Entry;
import com.cmdpro.datanessence.screen.DataTabletScreen;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class DataTabletEditorScreen
extends DataTabletScreen {
    public boolean parenting;
    public Vector2i parentingTargetPos;
    public Entry draggingEntry;
    public HashMap<Entry, Vector2i> entryPositionOverrides = new HashMap();
    public HashMap<Entry, List<Entry>> entryParentOverrides = new HashMap();

    public DataTabletEditorScreen(Component pTitle) {
        super(pTitle);
    }

    @Override
    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        if (this.draggingEntry != null) {
            double mouseX = pMouseX + pDragX;
            double mouseY = pMouseY + pDragY;
            mouseX -= (double)x;
            mouseY -= (double)y;
            int posX = (int)Math.floor(((mouseX -= this.offsetX) + 10.0) / 20.0);
            int posY = (int)Math.floor(((mouseY -= this.offsetY) + 10.0) / 20.0);
            if (this.parenting) {
                this.parentingTargetPos = new Vector2i(posX, posY);
            } else if (!this.entryPositionOverrides.containsKey(this.draggingEntry)) {
                if (this.draggingEntry.x != posX && this.draggingEntry.y != posY) {
                    this.entryPositionOverrides.put(this.draggingEntry, new Vector2i(posX, posY));
                }
            } else {
                this.entryPositionOverrides.put(this.draggingEntry, new Vector2i(posX, posY));
            }
            return true;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (!this.isHoveringAnyEntry(pMouseX, pMouseY)) {
            boolean found = false;
            for (Entry destinationEntry : Entries.entries.values()) {
                if (!destinationEntry.tab.equals((Object)this.currentTab.id) || !this.isEntryUnlocked(destinationEntry)) continue;
                for (Entry sourceEntry : this.getEntryParentEntries(destinationEntry)) {
                    if (!sourceEntry.tab.equals((Object)this.currentTab.id) || !this.isHoveringLine(sourceEntry, destinationEntry, pMouseX, pMouseY)) continue;
                    List<Entry> parents = this.entryParentOverrides.getOrDefault(destinationEntry, destinationEntry.getParentEntries());
                    if (parents.contains(sourceEntry)) {
                        parents = new ArrayList<Entry>(parents);
                        parents.remove(sourceEntry);
                        this.entryParentOverrides.put(destinationEntry, parents);
                    }
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        if (this.draggingEntry != null && this.parenting) {
            Vector2i entryPosition = this.getEntryPosition(this.draggingEntry);
            int destinationX = x + entryPosition.x * 20 + (int)this.offsetX;
            int destinationY = y + entryPosition.y * 20 + (int)this.offsetY;
            int sourceX = x + this.parentingTargetPos.x * 20 + (int)this.offsetX;
            int sourceY = y + this.parentingTargetPos.y * 20 + (int)this.offsetY;
            this.drawLine(sourceX, sourceY, destinationX, destinationY, this.draggingEntry, null, delta, mouseX, mouseY);
        }
    }

    @Override
    public boolean clickEntry(Entry entry) {
        return true;
    }

    @Override
    public boolean clickEntry(Entry entry, int button) {
        this.parenting = button == 1;
        this.parentingTargetPos = new Vector2i((Vector2ic)this.getEntryPosition(entry));
        this.draggingEntry = entry;
        return true;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        if (this.parenting && this.draggingEntry != null) {
            for (Entry entry : Entries.entries.values()) {
                if (!entry.tab.equals((Object)this.currentTab.id) || !this.isEntryUnlocked(entry)) continue;
                Vector2i entryPosition = this.getEntryPosition(entry);
                if (entryPosition.x != this.parentingTargetPos.x || entryPosition.y != this.parentingTargetPos.y) continue;
                List<Entry> parents = this.entryParentOverrides.getOrDefault(entry, entry.getParentEntries());
                if (parents.contains(this.draggingEntry)) break;
                parents = new ArrayList<Entry>(parents);
                parents.add(this.draggingEntry);
                this.entryParentOverrides.put(entry, parents);
                break;
            }
        }
        this.parenting = false;
        this.draggingEntry = null;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public Color getLineColor1(Entry source, Entry destination, float pPartialTick, int pMouseX, int pMouseY) {
        Color color = super.getLineColor1(source, destination, pPartialTick, pMouseX, pMouseY);
        if (source != null && destination != null && this.isHoveringLine(source, destination, pMouseX, pMouseY) && !this.isHoveringAnyEntry(pMouseX, pMouseY)) {
            color = ColorUtil.blendColors((Color)color, (Color)Color.WHITE, (float)0.25f);
        }
        return color;
    }

    @Override
    public Color getLineColor2(Entry source, Entry destination, float pPartialTick, int pMouseX, int pMouseY) {
        Color color = super.getLineColor2(source, destination, pPartialTick, pMouseX, pMouseY);
        if (source != null && destination != null && this.isHoveringLine(source, destination, pMouseX, pMouseY) && !this.isHoveringAnyEntry(pMouseX, pMouseY)) {
            color = ColorUtil.blendColors((Color)color, (Color)Color.WHITE, (float)0.25f);
        }
        return color;
    }

    public boolean isHoveringLine(Entry source, Entry destination, double mouseX, double mouseY) {
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(x + imageWidth) && mouseY <= (double)(y + imageHeight)) {
            Vector2i sourcePos = this.getEntryPosition(source);
            Vector2i destinationPos = this.getEntryPosition(destination);
            int sourceX = x + sourcePos.x * 20 + (int)this.offsetX;
            int sourceY = y + sourcePos.y * 20 + (int)this.offsetY;
            int destinationX = x + destinationPos.x * 20 + (int)this.offsetX;
            int destinationY = y + destinationPos.y * 20 + (int)this.offsetY;
            Line2D.Double line = new Line2D.Double(sourceX, sourceY, destinationX, destinationY);
            Rectangle2D.Double cursor = new Rectangle2D.Double(mouseX, mouseY, 4.0, 4.0);
            return line.intersects(cursor);
        }
        return false;
    }

    public boolean isHoveringAnyEntry(double mouseX, double mouseY) {
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(x + imageWidth) && mouseY <= (double)(y + imageHeight)) {
            for (Entry entry : Entries.entries.values()) {
                if (!entry.tab.equals((Object)this.currentTab.id) || !this.isEntryUnlocked(entry)) continue;
                Vector2i entryPosition = this.getEntryPosition(entry);
                if (!(mouseX >= (double)(entryPosition.x * 20 - 10) + this.offsetX + (double)x) || !(mouseX <= (double)(entryPosition.x * 20 + 10) + this.offsetX + (double)x) || !(mouseY >= (double)(entryPosition.y * 20 - 10) + this.offsetY + (double)y) || !(mouseY <= (double)(entryPosition.y * 20 + 10) + this.offsetY + (double)y)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Vector2i getEntryPosition(Entry entry) {
        if (this.entryPositionOverrides.containsKey(entry)) {
            return this.entryPositionOverrides.get(entry);
        }
        return super.getEntryPosition(entry);
    }

    @Override
    public boolean isEntryUnlocked(Entry entry) {
        return true;
    }

    @Override
    public int getEntryCompletionStage(Entry entry) {
        return entry.completionStages.size();
    }

    @Override
    public List<Entry> getEntryParentEntries(Entry entry) {
        if (this.entryParentOverrides.containsKey(entry)) {
            return this.entryParentOverrides.get(entry);
        }
        return super.getEntryParentEntries(entry);
    }

    @Override
    public List<ResourceLocation> getEntryParents(Entry entry) {
        if (this.entryParentOverrides.containsKey(entry)) {
            return this.entryParentOverrides.get(entry).stream().map(i -> i.id).toList();
        }
        return super.getEntryParents(entry);
    }
}

