/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.toasts;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.registry.SoundRegistry;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class TierToast
implements Toast {
    private static final ResourceLocation TEXTURE = DataNEssence.locate("tier_toast");
    public int tier;
    public boolean playedSound;

    public TierToast(int tier) {
        this.tier = tier;
    }

    public Toast.Visibility render(GuiGraphics pGuiGraphics, ToastComponent pToastComponent, long pTimeSinceLastVisible) {
        pGuiGraphics.blitSprite(TEXTURE, 0, 0, this.width(), this.height());
        int i = 0xFFFF00;
        pGuiGraphics.drawString(pToastComponent.getMinecraft().font, (Component)Component.translatable((String)"data_tablet.tier_upgrade"), 30, 7, i | 0xFF000000, false);
        pGuiGraphics.drawString(pToastComponent.getMinecraft().font, (Component)Component.translatable((String)"data_tablet.tier", (Object[])new Object[]{this.tier}), 30, 18, i | 0xFF000000, false);
        if (!this.playedSound && pTimeSinceLastVisible > 0L) {
            this.playedSound = true;
            pToastComponent.getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.TIER_ADVANCED.value()), (float)1.0f, (float)1.0f));
        }
        return (double)pTimeSinceLastVisible >= 5000.0 * pToastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

