/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.effects;

import io.redspace.ironsspellbooks.effect.CustomDescriptionMobEffect;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEPotionEffectRegistry;
import net.acetheeldritchking.discerning_the_eldritch.utils.DTEConfig;
import net.acetheeldritchking.discerning_the_eldritch.utils.DTETags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

@EventBusSubscriber
public class AbracadabraPotionEffect
extends CustomDescriptionMobEffect {
    public AbracadabraPotionEffect() {
        super(MobEffectCategory.BENEFICIAL, 15661670);
    }

    public Component getDescriptionLine(MobEffectInstance instance) {
        int amp = instance.getAmplifier() + 1;
        float damageCapAmount = AbracadabraPotionEffect.getCapAmount(amp);
        return Component.translatable((String)"tooltip.discerning_the_eldritch.abracadabra_description", (Object[])new Object[]{(int)damageCapAmount}).withStyle(ChatFormatting.BLUE);
    }

    public static float getCapAmount(int level) {
        return (float)DTEConfig.abracadabraDamageCap / (float)level;
    }

    public static float getDamageCapAmount(int level, float damage) {
        return Mth.clamp((float)damage, (float)0.0f, (float)AbracadabraPotionEffect.getCapAmount(level));
    }

    @SubscribeEvent
    public static void damageCapEvent(LivingIncomingDamageEvent event) {
        if (DTEConfig.enableDamageCap) {
            LivingEntity entity = event.getEntity();
            DamageSource source = event.getSource();
            MobEffectInstance effect = entity.getEffect(DTEPotionEffectRegistry.ABRACADABRA_EFFECT);
            if (effect != null && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                int level = effect.getAmplifier() + 1;
                float baseDamage = event.getAmount();
                float newDamage = AbracadabraPotionEffect.getDamageCapAmount(level, baseDamage);
                event.setAmount(newDamage);
            }
        }
    }

    @SubscribeEvent
    public static void preventHexes(MobEffectEvent.Applicable event) {
        if (DTEConfig.enableHexPrevention) {
            LivingEntity entity = event.getEntity();
            Holder hexEffect = event.getEffectInstance().getEffect();
            MobEffectInstance effect = entity.getEffect(DTEPotionEffectRegistry.ABRACADABRA_EFFECT);
            if (effect != null && ((MobEffect)hexEffect.value()).getCategory() == MobEffectCategory.HARMFUL) {
                if (hexEffect.is(DTETags.BYPASS_ABRACADABRA)) {
                    event.setResult(MobEffectEvent.Applicable.Result.APPLY);
                } else {
                    event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
                }
            }
        }
    }
}

