/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.entity.mobs.gaoler;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.IAnimatedAttacker;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericCopyOwnerTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericFollowOwnerGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.melee.AttackAnimationData;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.NotIdioticNavigation;
import io.redspace.ironsspellbooks.entity.spells.EarthquakeAoe;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.util.OwnerHelper;
import java.util.List;
import java.util.UUID;
import net.acetheeldritchking.aces_spell_utils.entity.mobs.UniqueAbstractSpellCastingMob;
import net.acetheeldritchking.discerning_the_eldritch.entity.mobs.goals.GaolerAnimatedWarlockAttackGoal;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEEntityRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTESoundRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.SpellRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GaolerEntity
extends UniqueAbstractSpellCastingMob
implements IMagicSummon,
GeoAnimatable,
IAnimatedAttacker {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected LivingEntity cachedSummoner;
    protected UUID summonerUUID;
    private int riseAnimationTime = 130;
    private static final EntityDataAccessor<Boolean> DATA_IS_PLAYING_RISE_ANIM = SynchedEntityData.defineId(GaolerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    RawAnimation animationToPlay = null;
    private final AnimationController<GaolerEntity> animationController = new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate);
    private final AnimationController<GaolerEntity> attackAnimationController = new AnimationController((GeoAnimatable)this, "attack_controller", 0, this::attackPredicate);
    private final AnimationController<GaolerEntity> castingAnimationController = new AnimationController((GeoAnimatable)this, "casting_controller", 0, this::castingPredicate);

    public GaolerEntity(EntityType<? extends UniqueAbstractSpellCastingMob> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 0;
        this.lookControl = this.createLookControl();
        this.moveControl = this.createMoveControl();
        this.noCulling = true;
    }

    public GaolerEntity(Level level, LivingEntity owner, boolean playAnimation) {
        this((EntityType<? extends UniqueAbstractSpellCastingMob>)((EntityType)DTEEntityRegistry.GAOLER_ENTITY.get()), level);
        if (playAnimation) {
            this.triggerRiseAnimation();
        }
    }

    protected LookControl createLookControl() {
        return new LookControl((Mob)this){

            protected float rotateTowards(float from, float to, float maxDelta) {
                return super.rotateTowards(from, to, maxDelta * 2.5f);
            }

            protected boolean resetXRotOnTick() {
                return GaolerEntity.this.getTarget() == null;
            }
        };
    }

    protected MoveControl createMoveControl() {
        return new MoveControl(this, (Mob)this){

            protected float rotlerp(float sourceAngle, float targetAngle, float maximumChange) {
                double z;
                double x = this.wantedX - this.mob.getX();
                if (x * x + (z = this.wantedZ - this.mob.getZ()) * z < 0.5) {
                    return sourceAngle;
                }
                return super.rotlerp(sourceAngle, targetAngle, maximumChange * 0.25f);
            }
        };
    }

    protected PathNavigation createNavigation(Level level) {
        return new NotIdioticNavigation((Mob)this, level);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new GaolerAnimatedWarlockAttackGoal(this, 1.5, 10, 25).setMoveset(List.of(new AttackAnimationData(39, "slam_1", new int[]{24}), new AttackAnimationData(37, "upper_cut", new int[]{22}))).setComboChance(1.2f).setMeleeAttackInverval(10, 25).setMeleeMovespeedModifier(1.5f).setMeleeBias(0.5f, 1.0f).setSingleUseSpell((AbstractSpell)SpellRegistry.SONIC_BOOM_SPELL.get(), 10, 15, 10, 10).setSpellQuality(15.0f, 15.0f));
        this.goalSelector.addGoal(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, () -> ((GaolerEntity)this).getSummoner(), (double)0.9f, 10.0f, 2.0f, false, 50.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true));
        this.targetSelector.addGoal(1, (Goal)new GenericOwnerHurtByTargetGoal((Mob)this, () -> ((GaolerEntity)this).getSummoner()));
        this.targetSelector.addGoal(2, (Goal)new GenericOwnerHurtTargetGoal((Mob)this, () -> ((GaolerEntity)this).getSummoner()));
        this.targetSelector.addGoal(3, (Goal)new GenericCopyOwnerTargetGoal((PathfinderMob)this, () -> ((GaolerEntity)this).getSummoner()));
        this.targetSelector.addGoal(4, (Goal)new GenericHurtByTargetGoal((PathfinderMob)this, entity -> entity == this.getSummoner()).setAlertOthers(new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 25.5).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.MAX_HEALTH, 350.0).add(Attributes.ARMOR, 15.0).add(Attributes.ARMOR_TOUGHNESS, 4.0).add(Attributes.FOLLOW_RANGE, 45.0).add(Attributes.ENTITY_INTERACTION_RANGE, 6.5).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public boolean isAlliedTo(Entity entityIn) {
        return super.isAlliedTo(entityIn) || this.isAlliedHelper(entityIn);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)DTESoundRegistry.GAOLER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)DTESoundRegistry.GAOLER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)DTESoundRegistry.GAOLER_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)DTESoundRegistry.GAOLER_STEP.get(), 10.0f, 1.0f);
    }

    public void die(DamageSource pDamageSource) {
        this.onDeathHelper();
        super.die(pDamageSource);
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
    }

    public void onUnSummon() {
        if (!this.level().isClientSide) {
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.SCULK_SOUL, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            this.discard();
        }
    }

    public boolean doHurtTarget(Entity entity) {
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(15, this.position(), 12.0f));
        MagicManager.spawnParticles((Level)entity.level(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ELDRITCH.get()).getTargetingColor(), 5.0f), (double)entity.getX(), (double)0.3, (double)entity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        return Utils.doMeleeAttack((Mob)this, (Entity)entity, (DamageSource)SpellRegistries.CONJURE_GAOLER.get().getDamageSource((Entity)this, this.getSummoner()));
    }

    public boolean canDisableShield() {
        return true;
    }

    public boolean dampensVibrations() {
        return true;
    }

    private int getHeartBeatDelay() {
        return 40 - Mth.floor((float)(Mth.clamp((float)20.0f, (float)0.0f, (float)1.0f) * 30.0f));
    }

    public void applyDarknessAround(ServerLevel level, Vec3 pos, @javax.annotation.Nullable Entity source, int radius) {
        MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.DARKNESS, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround((ServerLevel)level, (Entity)source, (Vec3)pos, (double)radius, (MobEffectInstance)mobeffectinstance, (int)200);
        List entitiesNearby = level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)radius));
        for (LivingEntity targets : entitiesNearby) {
            targets.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 200, 1, false, false, false));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
        controllers.add(this.attackAnimationController);
        controllers.add(this.castingAnimationController);
    }

    private PlayState predicate(AnimationState<GaolerEntity> event) {
        if (!this.isPlayingRiseAnimation()) {
            if (event.isMoving() && this.animationToPlay == null) {
                event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            if (!event.isMoving() && this.animationToPlay == null) {
                event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("spawn"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState attackPredicate(AnimationState<GaolerEntity> event) {
        AnimationController controller = event.getController();
        if (!this.isPlayingRiseAnimation()) {
            if (this.animationToPlay != null) {
                controller.forceAnimationReset();
                controller.setAnimation(this.animationToPlay);
                this.animationToPlay = null;
            }
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("spawn"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState castingPredicate(AnimationState<GaolerEntity> event) {
        if (!this.isPlayingRiseAnimation()) {
            if (this.isCasting() && this.animationToPlay == null) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("long_cast"));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay("spawn"));
        }
        return PlayState.STOP;
    }

    public void playAnimation(String animationId) {
        try {
            this.animationToPlay = RawAnimation.begin().thenPlay(animationId);
        }
        catch (Exception ignored) {
            IronsSpellbooks.LOGGER.error("Entity {} Failed to play animation: {}", (Object)this, (Object)animationId);
        }
    }

    public boolean isAnimating() {
        return this.animationController.getAnimationState() != AnimationController.State.STOPPED || super.isAnimating();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    private void clientDiggingParticles(LivingEntity livingEntity) {
        RandomSource randomSource = this.getRandom();
        BlockState blockState = this.getBlockStateOn();
        if (blockState.getRenderShape() != RenderShape.INVISIBLE) {
            for (int i = 0; i < 30; ++i) {
                double x = livingEntity.getX() + (double)Mth.randomBetween((RandomSource)randomSource, (float)-0.7f, (float)0.7f);
                double y = livingEntity.getY();
                double z = livingEntity.getZ() + (double)Mth.randomBetween((RandomSource)randomSource, (float)-0.7f, (float)0.7f);
                livingEntity.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), x, y, z, 0.0, 0.0, 0.0);
                livingEntity.playSound(SoundEvents.WARDEN_DIG, 10.0f, this.getVoicePitch());
            }
        }
    }

    public boolean isPlayingRiseAnimation() {
        return (Boolean)this.entityData.get(DATA_IS_PLAYING_RISE_ANIM);
    }

    public void triggerRiseAnimation() {
        this.entityData.set(DATA_IS_PLAYING_RISE_ANIM, (Object)true);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        ServerLevel serverLevel = (ServerLevel)this.level();
        if (this.tickCount % 120 == 0) {
            this.applyDarknessAround(serverLevel, this.position(), (Entity)this, 25);
        }
    }

    protected boolean isImmobile() {
        return this.isPlayingRiseAnimation() || super.isImmobile();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isPlayingRiseAnimation()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    private void spawnVisualEarthquake() {
        EarthquakeAoe aoe = new EarthquakeAoe(this.level());
        aoe.moveTo(this.position());
        aoe.setOwner((Entity)this);
        aoe.setCircular();
        aoe.setRadius(5.0f);
        aoe.setDuration(this.riseAnimationTime);
        aoe.setDamage(1.0f);
        aoe.setSlownessAmplifier(0);
        this.level().addFreshEntity((Entity)aoe);
    }

    public void tick() {
        if (this.isPlayingRiseAnimation()) {
            if (this.level().isClientSide) {
                this.clientDiggingParticles((LivingEntity)this);
            }
            if (!this.level().isClientSide() && this.riseAnimationTime == 130) {
                this.spawnVisualEarthquake();
            }
            if (this.riseAnimationTime >= 130) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.WARDEN_EMERGE, this.getSoundSource(), 5.0f, this.getVoicePitch(), false);
            }
            if (--this.riseAnimationTime <= 5) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)DTESoundRegistry.GAOLER_ROAR.get(), this.getSoundSource(), 10.5f, this.getVoicePitch(), false);
            }
            if (--this.riseAnimationTime < 0) {
                this.entityData.set(DATA_IS_PLAYING_RISE_ANIM, (Object)false);
                this.setXRot(0.0f);
                this.setOldPosAndRot();
            }
        } else {
            super.tick();
        }
        if (this.level().isClientSide() && this.tickCount % this.getHeartBeatDelay() == 0 && !this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.WARDEN_HEARTBEAT, this.getSoundSource(), 5.0f, this.getVoicePitch(), false);
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.summonerUUID = OwnerHelper.deserializeOwner((CompoundTag)pCompound);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        OwnerHelper.serializeOwner((CompoundTag)pCompound, (UUID)this.summonerUUID);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_PLAYING_RISE_ANIM, (Object)false);
    }
}

