/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.entity.mobs.untold_behemoth;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.IAnimatedAttacker;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericCopyOwnerTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericFollowOwnerGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.melee.AttackAnimationData;
import io.redspace.ironsspellbooks.entity.mobs.wizards.GenericAnimatedWarlockAttackGoal;
import io.redspace.ironsspellbooks.util.OwnerHelper;
import java.util.List;
import java.util.UUID;
import net.acetheeldritchking.aces_spell_utils.entity.mobs.UniqueAbstractSpellCastingMob;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEEntityRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.SpellRegistries;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class UntoldBehemothEntity
extends UniqueAbstractSpellCastingMob
implements IMagicSummon,
GeoAnimatable,
IAnimatedAttacker {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected UUID summonerUUID;
    RawAnimation animationToPlay = null;
    private final AnimationController<UntoldBehemothEntity> attackAnimationController = new AnimationController((GeoAnimatable)this, "attack_controller", 0, this::attackPredicate);
    private final AnimationController<UntoldBehemothEntity> animationController = new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate);
    private final AnimationController<UntoldBehemothEntity> castingAnimationController = new AnimationController((GeoAnimatable)this, "casting_controller", 0, this::castingPredicate);

    public UntoldBehemothEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 0;
        this.lookControl = this.createLookControl();
        this.moveControl = this.createMoveControl();
        this.noCulling = true;
    }

    public UntoldBehemothEntity(Level level, LivingEntity owner) {
        this((EntityType<? extends PathfinderMob>)((EntityType)DTEEntityRegistry.UNTOLD_BEHEMOTH.get()), level);
    }

    protected LookControl createLookControl() {
        return new LookControl((Mob)this){

            protected float rotateTowards(float from, float to, float maxDelta) {
                return super.rotateTowards(from, to, maxDelta * 2.5f);
            }

            protected boolean resetXRotOnTick() {
                return UntoldBehemothEntity.this.getTarget() == null;
            }
        };
    }

    protected MoveControl createMoveControl() {
        return new MoveControl(this, (Mob)this){

            protected float rotlerp(float sourceAngle, float targetAngle, float maximumChange) {
                double z;
                double x = this.wantedX - this.mob.getX();
                if (x * x + (z = this.wantedZ - this.mob.getZ()) * z < 0.5) {
                    return sourceAngle;
                }
                return super.rotlerp(sourceAngle, targetAngle, maximumChange * 0.25f);
            }
        };
    }

    public void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new GenericAnimatedWarlockAttackGoal((PathfinderMob)this, 1.5, 5, 10).setMoveset(List.of(new AttackAnimationData(20, "whack_1", new int[]{16}), new AttackAnimationData(20, "whack_2", new int[]{16}))).setComboChance(1.5f).setMeleeAttackInverval(10, 25).setMeleeBias(0.8f, 1.0f).setMeleeMovespeedModifier(1.2f).setSingleUseSpell((AbstractSpell)SpellRegistry.STOMP_SPELL.get(), 10, 15, 1, 3).setSpellQuality(0.5f, 0.15f));
        this.goalSelector.addGoal(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, () -> ((UntoldBehemothEntity)this).getSummoner(), (double)0.9f, 8.0f, 2.0f, false, 50.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new GenericOwnerHurtByTargetGoal((Mob)this, () -> ((UntoldBehemothEntity)this).getSummoner()));
        this.targetSelector.addGoal(2, (Goal)new GenericOwnerHurtTargetGoal((Mob)this, () -> ((UntoldBehemothEntity)this).getSummoner()));
        this.targetSelector.addGoal(3, (Goal)new GenericCopyOwnerTargetGoal((PathfinderMob)this, () -> ((UntoldBehemothEntity)this).getSummoner()));
        this.targetSelector.addGoal(4, (Goal)new GenericHurtByTargetGoal((PathfinderMob)this, entity -> entity == this.getSummoner()).setAlertOthers(new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ATTACK_KNOCKBACK, 0.2).add(Attributes.MAX_HEALTH, 65.0).add(Attributes.ARMOR, 5.0).add(Attributes.FOLLOW_RANGE, 45.0).add(Attributes.ENTITY_INTERACTION_RANGE, 2.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public boolean isAlliedTo(Entity entityIn) {
        return super.isAlliedTo(entityIn) || this.isAlliedHelper(entityIn);
    }

    public void die(DamageSource pDamageSource) {
        this.onDeathHelper();
        super.die(pDamageSource);
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
    }

    public void onUnSummon() {
        if (!this.level().isClientSide) {
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.ENCHANT, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            this.discard();
        }
    }

    public boolean doHurtTarget(Entity entity) {
        return Utils.doMeleeAttack((Mob)this, (Entity)entity, (DamageSource)SpellRegistries.CONJURE_FORSAKE_AID.get().getDamageSource((Entity)this, this.getSummoner()));
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return this.shouldIgnoreDamage(pSource) ? false : super.hurt(pSource, pAmount);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
        controllers.add(this.attackAnimationController);
        controllers.add(this.castingAnimationController);
    }

    private PlayState predicate(AnimationState<UntoldBehemothEntity> event) {
        if (event.isMoving() && this.animationToPlay == null) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (!event.isMoving() && this.animationToPlay == null) {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState attackPredicate(AnimationState<UntoldBehemothEntity> event) {
        AnimationController controller = event.getController();
        if (this.animationToPlay != null) {
            controller.forceAnimationReset();
            controller.setAnimation(this.animationToPlay);
            this.animationToPlay = null;
        }
        return PlayState.CONTINUE;
    }

    private PlayState castingPredicate(AnimationState<UntoldBehemothEntity> event) {
        if (this.isCasting() && this.animationToPlay == null) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("stomp_cast"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void playAnimation(String animationId) {
        try {
            this.animationToPlay = RawAnimation.begin().thenPlay(animationId);
        }
        catch (Exception ignored) {
            IronsSpellbooks.LOGGER.error("Entity {} Failed to play animation: {}", (Object)this, (Object)animationId);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.summonerUUID = OwnerHelper.deserializeOwner((CompoundTag)pCompound);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        OwnerHelper.serializeOwner((CompoundTag)pCompound, (UUID)this.summonerUUID);
    }
}

