/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.entity.spells.crystal_carve;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.acetheeldritchking.discerning_the_eldritch.DiscerningTheEldritch;
import net.acetheeldritchking.discerning_the_eldritch.entity.spells.crystal_carve.CrystalCarveEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class CrystalCarveRenderer
extends EntityRenderer<CrystalCarveEntity> {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{DiscerningTheEldritch.id("textures/entity/crystal_carve/crystal_carve_1.png"), DiscerningTheEldritch.id("textures/entity/crystal_carve/crystal_carve_2.png"), DiscerningTheEldritch.id("textures/entity/crystal_carve/crystal_carve_3.png"), DiscerningTheEldritch.id("textures/entity/crystal_carve/crystal_carve_4.png")};
    private static final ResourceLocation[] TEXTURES_FINAL = new ResourceLocation[]{DiscerningTheEldritch.id("textures/entity/crystal_carve_final/crystal_carve_final_1.png"), DiscerningTheEldritch.id("textures/entity/crystal_carve_final/crystal_carve_final_2.png"), DiscerningTheEldritch.id("textures/entity/crystal_carve_final/crystal_carve_final_3.png"), DiscerningTheEldritch.id("textures/entity/crystal_carve_final/crystal_carve_final_4.png")};

    public CrystalCarveRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(CrystalCarveEntity carver, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        PoseStack.Pose pose = poseStack.last();
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f - carver.getYRot()));
        poseStack.mulPose(Axis.ZP.rotationDegrees(carver.getXRot()));
        float randomZ = new Random(31L * (long)carver.getId()).nextInt(-5, 5);
        poseStack.mulPose(Axis.XP.rotationDegrees(randomZ));
        this.drawSlash(pose, carver, bufferSource, carver.getBbWidth() * 1.5f, carver.isMirrored());
        poseStack.popPose();
        super.render((Entity)carver, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    private void drawSlash(PoseStack.Pose pose, CrystalCarveEntity entity, MultiBufferSource bufferSource, float width, boolean mirrored) {
        Matrix4f poseMatrix = pose.pose();
        Matrix3f normalMatrix = pose.normal();
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(entity)));
        float halfWidth = width * 0.5f;
        float height = entity.getBbHeight() * 0.5f;
        consumer.addVertex(poseMatrix, -halfWidth, height, -halfWidth).setColor(255, 255, 255, 255).setUv(0.0f, mirrored ? 0.0f : 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(poseMatrix, halfWidth, height, -halfWidth).setColor(255, 255, 255, 255).setUv(1.0f, mirrored ? 0.0f : 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(poseMatrix, halfWidth, height, halfWidth).setColor(255, 255, 255, 255).setUv(1.0f, mirrored ? 1.0f : 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(poseMatrix, -halfWidth, height, halfWidth).setColor(255, 255, 255, 255).setUv(0.0f, mirrored ? 1.0f : 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(CrystalCarveEntity crystalCarveEntity) {
        if (crystalCarveEntity.getIsFinal()) {
            int frame = crystalCarveEntity.tickCount / crystalCarveEntity.ticksPerFrame % TEXTURES_FINAL.length;
            return TEXTURES_FINAL[frame];
        }
        int frame = crystalCarveEntity.tickCount / crystalCarveEntity.ticksPerFrame % TEXTURES.length;
        return TEXTURES[frame];
    }
}

