/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.entity.spells.esoteric_strike;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.acetheeldritchking.discerning_the_eldritch.DiscerningTheEldritch;
import net.acetheeldritchking.discerning_the_eldritch.entity.spells.esoteric_strike.EsotericStrike;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class EsotericStrikeRenderer
extends EntityRenderer<EsotericStrike> {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{DiscerningTheEldritch.id("textures/entity/esoteric_strike/esoteric_strike_1.png"), DiscerningTheEldritch.id("textures/entity/esoteric_strike/esoteric_strike_2.png"), DiscerningTheEldritch.id("textures/entity/esoteric_strike/esoteric_strike_3.png"), DiscerningTheEldritch.id("textures/entity/esoteric_strike/esoteric_strike_4.png")};

    public EsotericStrikeRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(EsotericStrike esotericEdge, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        PoseStack.Pose pose = poseStack.last();
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f - esotericEdge.getYRot()));
        poseStack.mulPose(Axis.ZP.rotationDegrees(esotericEdge.getXRot()));
        float randomZ = new Random(31L * (long)esotericEdge.getId()).nextInt(-5, 5);
        poseStack.mulPose(Axis.XP.rotationDegrees(randomZ));
        this.drawSlash(pose, esotericEdge, bufferSource, esotericEdge.getBbWidth() * 1.5f, esotericEdge.isMirrored());
        poseStack.popPose();
        super.render((Entity)esotericEdge, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    private void drawSlash(PoseStack.Pose pose, EsotericStrike entity, MultiBufferSource bufferSource, float width, boolean mirrored) {
        Matrix4f poseMatrix = pose.pose();
        Matrix3f normalMatrix = pose.normal();
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(entity)));
        float halfWidth = width * 0.5f;
        float height = entity.getBbHeight() * 0.5f;
        consumer.addVertex(poseMatrix, -halfWidth, height, -halfWidth).setColor(255, 255, 255, 255).setUv(0.0f, mirrored ? 0.0f : 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(poseMatrix, halfWidth, height, -halfWidth).setColor(255, 255, 255, 255).setUv(1.0f, mirrored ? 0.0f : 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(poseMatrix, halfWidth, height, halfWidth).setColor(255, 255, 255, 255).setUv(1.0f, mirrored ? 1.0f : 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(poseMatrix, -halfWidth, height, halfWidth).setColor(255, 255, 255, 255).setUv(0.0f, mirrored ? 1.0f : 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(EsotericStrike esotericStrike) {
        int frame = esotericStrike.tickCount / esotericStrike.ticksPerFrame % TEXTURES.length;
        return TEXTURES[frame];
    }
}

