/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.entity.spells.razor_blade;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import java.util.Collections;
import java.util.UUID;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEDamageTypes;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEEntityRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTESoundRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RazorBlade
extends LivingEntity
implements GeoEntity,
AntiMagicSusceptible,
GeoAnimatable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private float damage;
    private int age;
    private DamageSource damageSource;
    private final RawAnimation RISE_ANIM = RawAnimation.begin().thenPlay("rise");
    private final RawAnimation FALL_ANIM = RawAnimation.begin().thenPlay("fall");
    private final RawAnimation IDLE_ANIM = RawAnimation.begin().thenPlay("idle");
    private final AnimationController<RazorBlade> animationController = new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate);
    private final AnimationController<RazorBlade> riseAnimationController = new AnimationController((GeoAnimatable)this, "rise_controller", 0, this::risePredicate);

    public RazorBlade(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public RazorBlade(Level level, LivingEntity owner, float damage) {
        this((EntityType<? extends LivingEntity>)((EntityType)DTEEntityRegistry.RAZOR_BLADE.get()), level);
        this.setOwner(owner);
        this.setDamage(damage);
    }

    public void onAntiMagic(MagicData playerMagicData) {
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    public void tick() {
        if (!this.level().isClientSide) {
            if (this.age > 150) {
                this.discard();
            } else {
                if (this.age < 1) {
                    this.playSound((SoundEvent)DTESoundRegistry.RAZOR_UNSHEATHED.get(), 1.0f, 1.0f);
                }
                if (this.age < 130 && this.age % 20 == 0) {
                    this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.1)).forEach(this::dealDamage);
                }
            }
            if (this.age == 100 && Utils.random.nextFloat() < 0.4f) {
                this.playSound((SoundEvent)DTESoundRegistry.RAZOR_SHEATHED.get(), 1.0f, 1.0f);
            }
        }
        ++this.age;
    }

    public boolean dealDamage(LivingEntity target) {
        if (this.damageSource == null) {
            this.damageSource = new DamageSource(DamageSources.getHolderFromResource((Entity)target, DTEDamageTypes.RAZOR_DAMAGE), (Entity)this, (Entity)this.getOwner());
        }
        if (target != this.getOwner() && DamageSources.applyDamage((Entity)target, (float)this.damage, (DamageSource)this.damageSource)) {
            target.invulnerableTime = 0;
            return true;
        }
        return false;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUUID = owner == null ? null : owner.getUUID();
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (!pSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    @Nullable
    public LivingEntity getOwner() {
        ServerLevel serverLevel;
        Entity entity;
        Level level;
        if (this.owner == null && this.ownerUUID != null && (level = this.level()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            LivingEntity livingEntity;
            this.owner = livingEntity = (LivingEntity)entity;
        }
        return this.owner;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return Collections.singleton(ItemStack.EMPTY);
    }

    public ItemStack getItemBySlot(EquipmentSlot equipmentSlot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot equipmentSlot, ItemStack itemStack) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.age = compound.getInt("Age");
        if (compound.hasUUID("Owner")) {
            this.ownerUUID = compound.getUUID("Owner");
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Age", this.age);
        if (this.ownerUUID != null) {
            compound.putUUID("Owner", this.ownerUUID);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.animationController);
        controllerRegistrar.add(this.riseAnimationController);
    }

    private PlayState predicate(AnimationState<RazorBlade> event) {
        AnimationController controller = event.getController();
        if (this.age > 100 && Utils.random.nextFloat() < 0.05f) {
            controller.setAnimation(this.FALL_ANIM);
        } else if (controller.getAnimationState() == AnimationController.State.STOPPED) {
            controller.setAnimation(this.IDLE_ANIM);
        }
        return PlayState.CONTINUE;
    }

    private PlayState risePredicate(AnimationState<RazorBlade> event) {
        AnimationController controller = event.getController();
        if (this.age < 10) {
            controller.setAnimation(this.RISE_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

