/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.entity.spells.rift_walker;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AoeEntity;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.discerning_the_eldritch.particle.DTEParticleHelper;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEEntityRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTESoundRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.SpellRegistries;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class UnstableRiftEntity
extends AoeEntity {
    private Entity toTrack;
    public final int delay = 20;

    public UnstableRiftEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setCircular();
    }

    public UnstableRiftEntity(Level level, LivingEntity owner, float damage, float radius) {
        this((EntityType<? extends Projectile>)((EntityType)DTEEntityRegistry.UNSTABLE_RIFT.get()), level);
        this.setOwner((Entity)owner);
        this.setRadius(radius);
        this.setDamage(damage);
    }

    public void applyEffect(LivingEntity target) {
    }

    public void setTracking(Entity entity) {
        this.toTrack = entity;
    }

    public void tick() {
        if (this.toTrack != null && this.tickCount < 10) {
            this.setPos(this.toTrack.position());
        } else if (this.tickCount == 20) {
            this.playSound((SoundEvent)DTESoundRegistry.RIFT_WALKER_CAST.get(), 1.0f, (float)Utils.random.nextIntBetweenInclusive(8, 12) * 0.1f);
            if (!this.level().isClientSide) {
                int r = 184;
                int g = 11;
                int b = 106;
                float rf = (float)r / 255.0f;
                float gf = (float)g / 255.0f;
                float bf = (float)b / 255.0f;
                Vector3f colorRGB = new Vector3f(rf, gf, bf);
                Vec3 center = this.getBoundingBox().getCenter();
                MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)DTEParticleHelper.RIFT_SLICE, (double)center.x, (double)center.y, (double)center.z, (int)10, (double)0.0, (double)0.0, (double)0.0, (double)0.18, (boolean)false);
                MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlastwaveParticleOptions(colorRGB, this.getRadius() * 0.55f), (double)center.x, (double)(center.y - 0.75), (double)center.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlastwaveParticleOptions(colorRGB, this.getRadius() * 0.9f), (double)center.x, (double)center.y, (double)center.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlastwaveParticleOptions(colorRGB, this.getRadius() * 0.55f), (double)center.x, (double)(center.y + 0.75), (double)center.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                float explosionRadius = this.getRadius();
                float explosionRadiusSqr = explosionRadius * explosionRadius;
                List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)explosionRadius));
                Vec3 locCenter = Utils.moveToRelativeGroundLevel((Level)this.level(), (Vec3)center, (int)2);
                locCenter = Utils.raycastForBlock((Level)this.level(), (Vec3)locCenter, (Vec3)locCenter.add(0.0, 3.0, 0.0), (ClipContext.Fluid)ClipContext.Fluid.NONE).getLocation().add(locCenter).scale(0.5);
                for (Entity entity : entities) {
                    double distSqr = entity.distanceToSqr(center);
                    if (!(distSqr < (double)explosionRadiusSqr) || !this.canHitEntity(entity) || Utils.hasLineOfSight((Level)this.level(), (Vec3)locCenter, (Vec3)entity.getBoundingBox().getCenter(), (boolean)false)) {
                        // empty if block
                    }
                    double p = Mth.clamp((double)(1.0 - distSqr / (double)explosionRadiusSqr + (double)0.4f), (double)0.0, (double)1.0);
                    float damage = (float)((double)this.damage * p);
                    DamageSources.applyDamage((Entity)entity, (float)damage, (DamageSource)SpellRegistries.RIFT_WALKER.get().getDamageSource((Entity)this, this.getOwner()));
                }
            }
        } else if (this.tickCount > 20) {
            this.discard();
        }
        if (this.level().isClientSide && this.tickCount < 10) {
            Vec3 pos = this.getBoundingBox().getCenter();
            for (int i = 0; i < 3; ++i) {
                Vec3 vec3 = Utils.getRandomVec3((double)1.0);
                vec3 = vec3.multiply(vec3).multiply((double)Mth.sign((double)vec3.x), (double)Mth.sign((double)vec3.y), (double)Mth.sign((double)vec3.z)).scale((double)this.getRadius()).add(pos);
                Vec3 motion = this.position().subtract(vec3).scale(0.125);
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, vec3.x, vec3.y - 0.5, vec3.z, motion.x, motion.y, motion.z);
            }
        }
    }

    protected boolean canHitTargetForGroundContext(LivingEntity target) {
        return true;
    }

    public EntityDimensions getDimensions(Pose pPose) {
        return EntityDimensions.scalable((float)(this.getRadius() * 2.0f), (float)(this.getRadius() * 2.0f));
    }

    public float getParticleCount() {
        return 0.0f;
    }

    public Optional<ParticleOptions> getParticle() {
        return Optional.empty();
    }
}

