/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.events;

import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import net.acetheeldritchking.aces_spell_utils.utils.ASUtils;
import net.acetheeldritchking.discerning_the_eldritch.entity.mobs.bosses.ascended_one.AscendedOneBoss;
import net.acetheeldritchking.discerning_the_eldritch.items.weapons.IceSpearItem;
import net.acetheeldritchking.discerning_the_eldritch.items.weapons.TheSnowgraveItem;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEAttachmentRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEPotionEffectRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.ItemRegistries;
import net.acetheeldritchking.discerning_the_eldritch.utils.DTEConfig;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class ServerEvents {
    @SubscribeEvent
    public static void onPlayerCastEvent(SpellPreCastEvent event) {
        ServerPlayer player;
        ServerPlayer player2;
        Player entity = event.getEntity();
        AbstractSpell spell = SpellRegistry.getSpell((String)event.getSpellId());
        boolean hasSilenceEffect = entity.hasEffect(DTEPotionEffectRegistry.SILENCE_POTION_EFFECT);
        if (entity instanceof ServerPlayer && !(player2 = (ServerPlayer)entity).level().isClientSide() && hasSilenceEffect) {
            event.setCanceled(true);
            int time = player2.getEffect(DTEPotionEffectRegistry.SILENCE_POTION_EFFECT).getDuration();
            String formattedTime = ASUtils.convertTicksToTime((int)time);
            if (player2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player2;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"display.discerning_the_eldritch.silence_warning").append(formattedTime).withStyle(s -> s.withColor(TextColor.fromRgb((int)0xF35F5F)))));
                serverPlayer.level().playSound(null, player2.getX(), player2.getY(), player2.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
        if (DTEConfig.enableInsanitySystem) {
            entity.getData(DTEAttachmentRegistry.INSANITY_METER);
            if (spell.getSchoolType() == SchoolRegistry.ELDRITCH.get() && (Integer)entity.getData(DTEAttachmentRegistry.INSANITY_METER) <= DTEConfig.maxInsanityValue) {
                entity.setData(DTEAttachmentRegistry.INSANITY_METER, (Object)((Integer)entity.getData(DTEAttachmentRegistry.INSANITY_METER) + 1));
                if ((Integer)entity.getData(DTEAttachmentRegistry.INSANITY_METER) == DTEConfig.maxInsanityValue && entity instanceof ServerPlayer) {
                    player2 = (ServerPlayer)entity;
                    if (player2.getRandom().nextFloat() * 100.0f < 35.0f) {
                        player2.connection.send((Packet)new ClientboundSetTitleTextPacket((Component)Component.translatable((String)"display.discerning_the_eldritch.insanity_warning_1").withStyle(s -> s.withColor(TextColor.fromRgb((int)0xF35F5F)))));
                    }
                    if (player2.getRandom().nextFloat() * 100.0f < 32.0f) {
                        player2.connection.send((Packet)new ClientboundSetTitleTextPacket((Component)Component.translatable((String)"display.discerning_the_eldritch.insanity_warning_2").withStyle(s -> s.withColor(TextColor.fromRgb((int)0xF35F5F)))));
                    }
                    if (player2.getRandom().nextFloat() * 100.0f < 35.0f) {
                        player2.connection.send((Packet)new ClientboundSetTitleTextPacket((Component)Component.translatable((String)"display.discerning_the_eldritch.insanity_warning_3").withStyle(s -> s.withColor(TextColor.fromRgb((int)0xF35F5F)))));
                    }
                    if (player2.getRandom().nextFloat() * 100.0f < 5.0f) {
                        player2.connection.send((Packet)new ClientboundSetTitleTextPacket((Component)Component.translatable((String)"display.discerning_the_eldritch.insanity_warning_4").withStyle(s -> s.withColor(TextColor.fromRgb((int)0xF35F5F)))));
                    }
                }
            }
        }
        boolean hasPresenceEffect = entity.hasEffect(DTEPotionEffectRegistry.METAPHYSICAL_POTION_EFFECT);
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).level().isClientSide() && hasPresenceEffect) {
            event.setCanceled(true);
            int time2 = player.getEffect(DTEPotionEffectRegistry.METAPHYSICAL_POTION_EFFECT).getDuration();
            String formattedTime2 = ASUtils.convertTicksToTime((int)time2);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"display.discerning_the_eldritch.presence_warning").append(formattedTime2).withStyle(s -> s.withColor(TextColor.fromRgb((int)0xF35F5F)))));
                serverPlayer.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(PlayerTickEvent.Post event) {
        Player entity = event.getEntity();
        if ((Integer)entity.getData(DTEAttachmentRegistry.INSANITY_METER) >= DTEConfig.maxInsanityValue && entity.tickCount % 100 == 0) {
            entity.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 100, 9, false, false, false));
        }
    }

    @SubscribeEvent
    public static void livingDamageEvent(LivingDamageEvent.Post event) {
        Player player;
        Entity sourceEntity = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        Entity projectile = event.getSource().getDirectEntity();
        if (sourceEntity != null && sourceEntity instanceof Player && ASUtils.hasCurio((Player)(player = (Player)sourceEntity), (Item)((Item)ItemRegistries.DIARY_OF_DECAY.get())) && projectile instanceof Projectile) {
            target.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 0, true, true, true));
        }
        if (sourceEntity instanceof LivingEntity) {
            LivingEntity livingTarget;
            LivingEntity livingEntity = (LivingEntity)sourceEntity;
            ItemStack mainhandItem = livingEntity.getMainHandItem();
            if (mainhandItem.getItem() instanceof IceSpearItem && target instanceof LivingEntity) {
                livingTarget = target;
                livingTarget.setTicksFrozen(100);
            }
            if (mainhandItem.getItem() instanceof TheSnowgraveItem && target instanceof LivingEntity) {
                livingTarget = target;
                livingTarget.setTicksFrozen(300);
            }
            if (livingEntity.hasEffect(DTEPotionEffectRegistry.MEND_FLESH_EFFECT) && DTEConfig.mendFleshLifesteal) {
                livingEntity.heal(1.5f);
                int count = 8;
                float radius = 0.25f;
                ASUtils.spawnParticlesInCircle((int)count, (float)radius, (float)0.5f, (float)0.1f, (LivingEntity)livingEntity, (ParticleOptions)ParticleTypes.SCULK_SOUL);
                if (!livingEntity.level().isClientSide) {
                    livingEntity.level().playSound((Entity)livingEntity, livingEntity.blockPosition(), SoundEvents.SCULK_CATALYST_BLOOM, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void livingIncomingDamageEvent(LivingIncomingDamageEvent event) {
        LivingEntity livingAttacker;
        LivingEntity livingTarget;
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        if (target instanceof LivingEntity && (livingTarget = target).hasEffect(DTEPotionEffectRegistry.METAPHYSICAL_POTION_EFFECT)) {
            event.setCanceled(true);
        }
        if (attacker instanceof LivingEntity && (livingAttacker = (LivingEntity)attacker).hasEffect(DTEPotionEffectRegistry.METAPHYSICAL_POTION_EFFECT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFallEvent(LivingFallEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && ASUtils.hasCurio((Player)(player = (Player)entity), (Item)((Item)ItemRegistries.IRONBOUND_FEATHER.get()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onExperienceGainedEvent(PlayerXpEvent.XpChange event) {
        Player attacker = event.getEntity();
        if (attacker.hasEffect(DTEPotionEffectRegistry.MEND_FLESH_EFFECT) && DTEConfig.mendFleshEXPGain) {
            float experienceGained = (float)event.getAmount() / 2.0f;
            attacker.heal(experienceGained);
            int count = 8;
            float radius = 0.25f;
            ASUtils.spawnParticlesInCircle((int)count, (float)radius, (float)0.5f, (float)0.1f, (LivingEntity)attacker, (ParticleOptions)ParticleTypes.SCULK_SOUL);
            if (!attacker.level().isClientSide) {
                attacker.level().playSound((Entity)attacker, attacker.blockPosition(), SoundEvents.SCULK_CATALYST_BLOOM, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void entityDamageCapEvent(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity;
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && entity instanceof LivingEntity && (livingEntity = entity) instanceof AscendedOneBoss) {
            AscendedOneBoss ascendedOneBoss = (AscendedOneBoss)livingEntity;
            if (DTEConfig.enableAscendedOneDamageCap) {
                float baseDamage = event.getOriginalDamage();
                float newDamage = ASUtils.basicDamageCap((float)baseDamage, (float)0.0f, (float)DTEConfig.ascendedOneDamageCap);
                event.setNewDamage(newDamage);
            }
        }
    }
}

