/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.items.curios;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.render.CinderousRarity;
import net.acetheeldritchking.aces_spell_utils.items.curios.SheathCurioItem;
import net.acetheeldritchking.discerning_the_eldritch.registries.ItemRegistries;
import net.acetheeldritchking.discerning_the_eldritch.utils.DTEConfig;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class PyriumSheathCurio
extends SheathCurioItem {
    public static int COOLDOWN = DTEConfig.pyriumSheathCooldown * 20;

    public PyriumSheathCurio() {
        super(new Item.Properties().stacksTo(1).rarity((Rarity)CinderousRarity.CINDEROUS_RARITY_PROXY.getValue()).fireResistant(), null);
    }

    protected int getCooldownTicks() {
        return DTEConfig.pyriumSheathCooldown * 20;
    }

    @SubscribeEvent
    public static void handleAbility(LivingIncomingDamageEvent event) {
        LivingEntity victim;
        ServerPlayer player;
        PyriumSheathCurio sheath = (PyriumSheathCurio)ItemRegistries.PYRIUM_SHEATH.get();
        Entity attacker = event.getSource().getEntity();
        if (attacker instanceof ServerPlayer && sheath.isEquippedBy((LivingEntity)(player = (ServerPlayer)attacker)) && sheath.tryProcCooldown((Player)player) && (victim = event.getEntity()) != attacker) {
            float getBaseDamage = event.getOriginalAmount();
            if (victim.isOnFire()) {
                event.setAmount(getBaseDamage * 1.5f);
            }
            victim.setRemainingFireTicks(120);
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap attr = LinkedHashMultimap.create();
        attr.put((Object)AttributeRegistry.FIRE_SPELL_POWER, (Object)new AttributeModifier(id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attr.put((Object)AttributeRegistry.FIRE_MAGIC_RESIST, (Object)new AttributeModifier(id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attr.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(id, 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return attr;
    }
}

