/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.items.curios;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.util.Utils;
import net.acetheeldritchking.aces_spell_utils.items.curios.SheathCurioItem;
import net.acetheeldritchking.aces_spell_utils.utils.ASRarities;
import net.acetheeldritchking.discerning_the_eldritch.entity.spells.razor_blade.RazorBlade;
import net.acetheeldritchking.discerning_the_eldritch.registries.ItemRegistries;
import net.acetheeldritchking.discerning_the_eldritch.utils.DTEConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class RazorSheathCurio
extends SheathCurioItem {
    public static int COOLDOWN = DTEConfig.razorSheathCooldown * 20;

    public RazorSheathCurio() {
        super(new Item.Properties().stacksTo(1).rarity((Rarity)ASRarities.ACCURSED_RARITY_PROXY.getValue()).fireResistant(), null);
    }

    protected int getCooldownTicks() {
        return DTEConfig.razorSheathCooldown * 20;
    }

    @SubscribeEvent
    public static void handleAbility(LivingDamageEvent.Pre event) {
        LivingEntity victim;
        ServerPlayer player;
        RazorSheathCurio sheath = (RazorSheathCurio)ItemRegistries.RAZOR_SHEATH.get();
        Entity attacker = event.getSource().getDirectEntity();
        if (attacker instanceof ServerPlayer && sheath.isEquippedBy((LivingEntity)(player = (ServerPlayer)attacker)) && sheath.tryProcCooldown((Player)player) && (victim = event.getEntity()) != attacker) {
            Vec3 victimPos = victim.position();
            int count = 7;
            int rings = 2;
            for (int r = 0; r < rings; ++r) {
                float fangs = count + r * r;
                int i = 0;
                while ((float)i < fangs) {
                    Vec3 spawn = victimPos.add(new Vec3(0.0, 0.0, 0.5 * (double)(r + 1)).yRot(victim.getYRot() * ((float)Math.PI / 180) + 6.281f / fangs * (float)i));
                    spawn = Utils.moveToRelativeGroundLevel((Level)player.level(), (Vec3)spawn, (int)2);
                    if (!player.level().getBlockState(BlockPos.containing((Position)spawn).below()).isAir()) {
                        RazorBlade razorBlade = new RazorBlade(player.level(), (LivingEntity)player, (float)(2.0 + player.getAttributeValue(Attributes.ATTACK_DAMAGE) * ((double)DTEConfig.razorSheathMultiplier / 100.0)));
                        razorBlade.moveTo(spawn);
                        razorBlade.setOwner((LivingEntity)player);
                        player.level().addFreshEntity((Entity)razorBlade);
                    }
                    ++i;
                }
            }
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap attr = LinkedHashMultimap.create();
        attr.put((Object)AttributeRegistry.BLOOD_SPELL_POWER, (Object)new AttributeModifier(id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attr.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(id, 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attr.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(id, 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return attr;
    }
}

