/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.items.custom;

import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import java.util.List;
import net.acetheeldritchking.aces_spell_utils.utils.ASRarities;
import net.acetheeldritchking.aces_spell_utils.utils.ASUtils;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTESoundRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.ItemRegistries;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FadingSculkLantern
extends Item {
    public FadingSculkLantern() {
        super(ItemPropertiesHelper.material().rarity((Rarity)ASRarities.SCULK_RARITY_PROXY.getValue()).stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"item.discerning_the_eldritch.fading_sculk_lantern.description").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                player.getCooldowns().addCooldown((Item)ItemRegistries.FADING_SCULK_LANTERN.get(), 200);
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"display.discerning_the_eldritch.fading_sculk_lantern_fail").withStyle(s -> s.withColor(TextColor.fromRgb((int)37525)))));
                this.onUseEffects((Player)serverPlayer, serverLevel, player.position(), false);
            }
        }
        player.swing(usedHand);
        return InteractionResultHolder.pass((Object)itemStack);
    }

    public void onUseEffects(Player player, ServerLevel serverLevel, Vec3 usePosition, boolean success) {
        serverLevel.playSound(null, usePosition.x, usePosition.y, usePosition.z, success ? DTESoundRegistry.SCULK_LANTERN_TOLL_SUCCESS : DTESoundRegistry.SCULK_LANTERN_TOLL, SoundSource.PLAYERS, 6.0f, 1.0f);
        ASUtils.spawnParticlesInRing((int)16, (float)0.25f, (float)1.25f, (float)2.25f, (float)0.5f, (float)0.1f, (LivingEntity)player, (ParticleOptions)ParticleTypes.SCULK_SOUL);
    }
}

