/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.registries;

import io.redspace.ironsspellbooks.api.attribute.MagicRangedAttribute;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="discerning_the_eldritch", bus=EventBusSubscriber.Bus.MOD)
public class DTEAttributeRegistry {
    private static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"discerning_the_eldritch");
    public static final DeferredHolder<Attribute, Attribute> RITUAL_MAGIC_RESIST = DTEAttributeRegistry.registerResistanceAttribute("ritual");
    public static final DeferredHolder<Attribute, Attribute> RITUAL_MAGIC_POWER = DTEAttributeRegistry.registerPowerAttribute("ritual");

    public static void register(IEventBus eventBus) {
        ATTRIBUTES.register(eventBus);
    }

    @SubscribeEvent
    public static void modifyEntityAttributes(EntityAttributeModificationEvent event) {
        event.getTypes().forEach(entityType -> ATTRIBUTES.getEntries().forEach(attributeDeferredHolder -> event.add(entityType, (Holder)attributeDeferredHolder)));
    }

    private static DeferredHolder<Attribute, Attribute> registerResistanceAttribute(String id) {
        return ATTRIBUTES.register(id + "_magic_resist", () -> new MagicRangedAttribute("attribute.discerning_the_eldritch." + id + "_magic_resist", 1.0, -100.0, 100.0).setSyncable(true));
    }

    private static DeferredHolder<Attribute, Attribute> registerPowerAttribute(String id) {
        return ATTRIBUTES.register(id + "_spell_power", () -> new MagicRangedAttribute("attribute.discerning_the_eldritch." + id + "_spell_power", 1.0, -100.0, 100.0).setSyncable(true));
    }

    private static DeferredHolder<Attribute, Attribute> registerAttribute(String id) {
        return ATTRIBUTES.register(id, () -> new MagicRangedAttribute("attribute.aces_spell_utils." + id, 1.0, -100.0, 100.0).setSyncable(true));
    }
}

