/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.spells.eldritch;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.events.SpellSummonEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerRecasts;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.capabilities.magic.SummonManager;
import io.redspace.ironsspellbooks.capabilities.magic.SummonedEntitiesCastData;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.aces_spell_utils.network.AddShaderEffectPacket;
import net.acetheeldritchking.aces_spell_utils.network.RemoveShaderEffectPacket;
import net.acetheeldritchking.aces_spell_utils.spells.ASSpellAnimations;
import net.acetheeldritchking.aces_spell_utils.utils.ASUtils;
import net.acetheeldritchking.discerning_the_eldritch.entity.mobs.gaoler.GaolerEntity;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEPotionEffectRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.ItemRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class ConjureGaolerSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"discerning_the_eldritch", (String)"conjure_gaoler");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ELDRITCH_RESOURCE).setMaxLevel(1).setCooldownSeconds(600.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.hp", (Object[])new Object[]{Utils.stringTruncation((double)this.getGaolerHealth(spellLevel, null), (int)2)}), Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getGaolerDamage(spellLevel, null), (int)2)}));
    }

    public ConjureGaolerSpell() {
        this.manaCostPerLevel = 100;
        this.baseSpellPower = 25;
        this.spellPowerPerLevel = 1;
        this.castTime = 100;
        this.baseManaCost = 500;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public boolean canBeCraftedBy(Player player) {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public boolean requiresLearning() {
        return false;
    }

    public AnimationHolder getCastStartAnimation() {
        return ASSpellAnimations.ANIMATION_GAOLER_SUMMON;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.WARDEN_HEARTBEAT);
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        Player player;
        if (entity instanceof Player && ASUtils.hasCurio((Player)(player = (Player)entity), (Item)((Item)ItemRegistries.KINGS_EFFIGY.get()))) {
            return 2;
        }
        return 1;
    }

    public void onRecastFinished(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        if (SummonManager.recastFinishedHelper((ServerPlayer)serverPlayer, (RecastInstance)recastInstance, (RecastResult)recastResult, (ICastDataSerializable)castDataSerializable) && ASUtils.hasCurio((Player)serverPlayer, (Item)((Item)ItemRegistries.KINGS_EFFIGY.get()))) {
            super.onRecastFinished(serverPlayer, recastInstance, recastResult, castDataSerializable);
        }
    }

    public ICastDataSerializable getEmptyCastData() {
        return new SummonedEntitiesCastData();
    }

    public void onServerPreCast(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        double radius = 15.0;
        List entitiesNearby = level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(radius));
        for (LivingEntity targets : entitiesNearby) {
            targets.addEffect(new MobEffectInstance(MobEffects.DARKNESS, this.getCastTime(spellLevel), 1, false, false, false));
        }
        entity.addEffect(new MobEffectInstance(MobEffects.DARKNESS, this.getCastTime(spellLevel), 1, false, false, false));
        entity.addEffect(new MobEffectInstance(DTEPotionEffectRegistry.PORTENT_EFFECT, 100, 1, false, false, false));
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new AddShaderEffectPacket("discerning_the_eldritch", "shaders/grayscale_darker.json"), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        super.onServerPreCast(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Player player;
        PlayerRecasts recasts = playerMagicData.getPlayerRecasts();
        int summonTimer = 1200;
        SummonedEntitiesCastData summonedEntitiesCastData = new SummonedEntitiesCastData();
        BlockPos pos = new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ());
        Vec3 lookDir = entity.getLookAngle();
        Vec3 flatDir = new Vec3(lookDir.x, 0.0, lookDir.z).normalize();
        double offset = 6.0;
        Vec3 spawnPos = entity.position().subtract(flatDir.scale(offset));
        if (entity instanceof Player && ASUtils.hasCurio((Player)(player = (Player)entity), (Item)((Item)ItemRegistries.KINGS_EFFIGY.get()))) {
            if (!recasts.hasRecastForSpell((AbstractSpell)this)) {
                this.spawnGaoler(spawnPos.x, spawnPos.y, spawnPos.z, entity, level, summonTimer, spellLevel, summonedEntitiesCastData, false);
                RecastInstance recastInstance = new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), summonTimer, castSource, (ICastDataSerializable)summonedEntitiesCastData);
                recasts.addRecast(recastInstance, playerMagicData);
            }
        } else {
            this.spawnGaoler(spawnPos.x, spawnPos.y, spawnPos.z, entity, level, summonTimer, spellLevel, summonedEntitiesCastData, true);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new RemoveShaderEffectPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnGaoler(double x, double y, double z, LivingEntity caster, Level level, int timer, int spellLevel, SummonedEntitiesCastData castData, boolean isFeral) {
        GaolerEntity gaoler = new GaolerEntity(level, caster, true);
        gaoler.setPos(x, y, z);
        gaoler.setOldPosAndRot();
        gaoler.lookAt((Entity)caster, 1.0f, 1.0f);
        gaoler.getAttributes().getInstance(Attributes.ATTACK_DAMAGE).setBaseValue((double)this.getGaolerDamage(spellLevel, caster));
        gaoler.getAttributes().getInstance(Attributes.MAX_HEALTH).setBaseValue((double)this.getGaolerHealth(spellLevel, caster));
        gaoler.setHealth(gaoler.getMaxHealth());
        GaolerEntity event = (GaolerEntity)((SpellSummonEvent)NeoForge.EVENT_BUS.post((Event)new SpellSummonEvent(caster, (LivingEntity)gaoler, this.spellId, spellLevel))).getCreature();
        level.addFreshEntity((Entity)event);
        SummonManager.initSummon((Entity)caster, (Entity)event, (int)timer, (SummonedEntitiesCastData)castData);
        if (isFeral) {
            SummonManager.removeSummon((Entity)gaoler);
        }
    }

    private float getGaolerDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 4.5f;
    }

    private float getGaolerHealth(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 20.5f;
    }
}

