/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.spells.eldritch;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.aces_spell_utils.spells.ASSpellAnimations;
import net.acetheeldritchking.aces_spell_utils.utils.ASUtils;
import net.acetheeldritchking.discerning_the_eldritch.entity.spells.esoteric_strike.EsotericStrike;
import net.acetheeldritchking.discerning_the_eldritch.particle.DTEParticleHelper;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTESoundRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class EsotericStrikeSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"discerning_the_eldritch", (String)"esoteric_strike");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ELDRITCH_RESOURCE).setMaxLevel(5).setCooldownSeconds(1.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{this.getDamageText(spellLevel, caster)}), Component.translatable((String)"ui.discerning_the_eldritch.extra_damage"), Component.translatable((String)"ui.discerning_the_eldritch.melee_damage"));
    }

    public EsotericStrikeSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 2;
        this.castTime = 0;
        this.baseManaCost = 25;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public AnimationHolder getCastStartAnimation() {
        return ASSpellAnimations.ANIMATION_SPELL_PUNCH;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)DTESoundRegistry.ESOTERIC_STRIKE.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float radius = 2.15f;
        float distance = 1.2f;
        Vec3 hitLocation = entity.position().add(0.0, (double)(entity.getBbHeight() * 0.3f), 0.0).add(entity.getForward().multiply((double)distance, (double)0.35f, (double)distance));
        List entities = entity.level().getEntities((Entity)entity, AABB.ofSize((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
        for (Entity target : entities) {
            if (!entity.isPickable() || !(entity.distanceToSqr(target) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)level, (Vec3)entity.getEyePosition(), (Vec3)target.getBoundingBox().getCenter(), (boolean)true) || target instanceof ItemEntity || !DamageSources.applyDamage((Entity)target, (float)this.getDamage(spellLevel, entity), (DamageSource)this.getDamageSource((Entity)entity))) continue;
            MagicManager.spawnParticles((Level)level, (ParticleOptions)DTEParticleHelper.ESOTERIC_SPARKS, (double)target.getX(), (double)(target.getY() + (double)(target.getBbHeight() * 0.5f)), (double)target.getZ(), (int)50, (double)(target.getBbWidth() * 0.5f), (double)(target.getBbHeight() * 0.5f), (double)(target.getBbWidth() * 0.5f), (double)0.03, (boolean)false);
            EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)level), (Entity)target, (DamageSource)this.getDamageSource((Entity)entity));
        }
        boolean mirrored = playerMagicData.getCastingEquipmentSlot().equals(SpellSelectionManager.OFFHAND);
        EsotericStrike swipe = new EsotericStrike(level, mirrored);
        swipe.moveTo(hitLocation);
        swipe.setYRot(entity.getYRot());
        level.addFreshEntity((Entity)swipe);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = ASUtils.getDamageForAttributes((AbstractSpell)this, (LivingEntity)caster, (int)spellLevel, (Holder)Attributes.ATTACK_DAMAGE, (float)0.35f);
        return baseDamage + this.getWeaponDamage(caster);
    }

    private float getWeaponDamage(LivingEntity caster) {
        float weaponDamage = Utils.getWeaponDamage((LivingEntity)caster);
        return weaponDamage;
    }

    private String getDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float weaponDamage = Utils.getWeaponDamage((LivingEntity)caster);
            String plus = "";
            if (weaponDamage > 0.0f) {
                plus = String.format(" (+%s)", Utils.stringTruncation((double)weaponDamage, (int)1));
            }
            String damage = Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1);
            return damage + plus;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }
}

