/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.spells.ice;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.aces_spell_utils.spells.ASSpellAnimations;
import net.acetheeldritchking.discerning_the_eldritch.DiscerningTheEldritch;
import net.acetheeldritchking.discerning_the_eldritch.entity.spells.crystal_carve.CrystalCarveEntity;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEAttachmentRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTESoundRegistry;
import net.acetheeldritchking.discerning_the_eldritch.utils.DTETags;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class CrystallineCarverSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"discerning_the_eldritch", (String)"crystalline_carver");
    private boolean isFinalCast;
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(5).setCooldownSeconds(35.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1)}), Component.translatable((String)"ui.discerning_the_eldritch.frozen_weapon_bonus"), Component.translatable((String)"ui.discerning_the_eldritch.damage_on_last_recast"));
    }

    public CrystallineCarverSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 2;
        this.castTime = 20;
        this.baseManaCost = 50;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        if (this.isFinalCast) {
            return CastType.LONG;
        }
        return CastType.INSTANT;
    }

    public AnimationHolder getCastStartAnimation() {
        if (this.isFinalCast) {
            return ASSpellAnimations.ANIMATION_RIGHT_HORIZONTAL_SWORD_SLASH;
        }
        return SpellAnimations.SLASH_ANIMATION;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return !this.isFinalCast;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public Optional<SoundEvent> getCastStartSound() {
        if (this.isFinalCast) {
            return Optional.of((SoundEvent)DTESoundRegistry.CRYSTALLINE_CARVER_FINISH.get());
        }
        return Optional.of((SoundEvent)DTESoundRegistry.CRYSTALLINE_CARVER_BASE.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return spellLevel;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 160, castSource, null), playerMagicData);
        }
        float radius = 3.25f;
        float distance = 1.5f;
        Vec3 hitLocation = entity.position().add(0.0, (double)(entity.getBbHeight() * 0.3f), 0.0).add(entity.getForward().multiply((double)distance, (double)0.35f, (double)distance));
        List entities = entity.level().getEntities((Entity)entity, AABB.ofSize((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
        for (Entity target : entities) {
            if (!entity.isPickable() || !(entity.distanceToSqr(target) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)level, (Vec3)entity.getEyePosition(), (Vec3)target.getBoundingBox().getCenter(), (boolean)true) || target instanceof ItemEntity || !(target instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)target;
            int frostbiteLevel = (Integer)target.getData(DTEAttachmentRegistry.FROSTBITE_LEVEL);
            DiscerningTheEldritch.LOGGER.debug("Applying chilled");
            target.setData(DTEAttachmentRegistry.FROSTBITE_LEVEL, (Object)(frostbiteLevel + 1));
            livingEntity.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.CHILLED, 60, 0, false, false, false));
            DiscerningTheEldritch.LOGGER.debug("Frostbite: " + String.valueOf(target.getData(DTEAttachmentRegistry.FROSTBITE_LEVEL)));
        }
        boolean mirrored = playerMagicData.getCastingEquipmentSlot().equals(SpellSelectionManager.OFFHAND);
        CrystalCarveEntity swipe = new CrystalCarveEntity(level, mirrored);
        swipe.moveTo(hitLocation);
        swipe.setYRot(entity.getYRot());
        swipe.setIsFinal(false);
        level.addFreshEntity((Entity)swipe);
        this.isFinalCast = playerMagicData.getPlayerRecasts().getRemainingRecastsForSpell(this.spellId.toString()) == 2;
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public void onRecastFinished(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        super.onRecastFinished(serverPlayer, recastInstance, recastResult, castDataSerializable);
        if (recastResult.isSuccess()) {
            float radius = 2.15f;
            float distance = 1.2f;
            Vec3 hitLocation = serverPlayer.position().add(0.0, (double)(serverPlayer.getBbHeight() * 0.3f), 0.0).add(serverPlayer.getForward().multiply((double)distance, (double)0.35f, (double)distance));
            List entities = serverPlayer.level().getEntities((Entity)serverPlayer, AABB.ofSize((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
            for (Entity target : entities) {
                if (serverPlayer.isPickable() && serverPlayer.distanceToSqr(target) < (double)(radius * radius) && Utils.hasLineOfSight((Level)serverPlayer.level(), (Vec3)serverPlayer.getEyePosition(), (Vec3)target.getBoundingBox().getCenter(), (boolean)true) && !(target instanceof ItemEntity)) {
                    float baseDamage = this.getDamage(recastInstance.getSpellLevel(), (LivingEntity)serverPlayer);
                    if (target instanceof LivingEntity) {
                        LivingEntity livingTarget = (LivingEntity)target;
                        if (livingTarget.hasEffect((Holder)MobEffectRegistry.CHILLED)) {
                            int amplifier = (Integer)target.getData(DTEAttachmentRegistry.FROSTBITE_LEVEL);
                            if (serverPlayer.getMainHandItem().is(DTETags.FROZEN_WEAPONS)) {
                                extraDamage = (baseDamage + (float)amplifier) * 1.5f;
                                if (DamageSources.applyDamage((Entity)target, (float)extraDamage, (DamageSource)this.getDamageSource((Entity)serverPlayer))) {
                                    MagicManager.spawnParticles((Level)serverPlayer.level(), (ParticleOptions)ParticleHelper.SNOWFLAKE, (double)target.getX(), (double)(target.getY() + (double)(target.getBbHeight() * 0.5f)), (double)target.getZ(), (int)50, (double)(target.getBbWidth() * 0.5f), (double)(target.getBbHeight() * 0.5f), (double)(target.getBbWidth() * 0.5f), (double)0.03, (boolean)false);
                                    EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)serverPlayer.level()), (Entity)target, (DamageSource)this.getDamageSource((Entity)serverPlayer));
                                    DiscerningTheEldritch.LOGGER.debug("Bonus damage (Icy): " + extraDamage);
                                }
                            } else {
                                extraDamage = baseDamage + (float)amplifier;
                                if (DamageSources.applyDamage((Entity)target, (float)extraDamage, (DamageSource)this.getDamageSource((Entity)serverPlayer))) {
                                    MagicManager.spawnParticles((Level)serverPlayer.level(), (ParticleOptions)ParticleHelper.SNOWFLAKE, (double)target.getX(), (double)(target.getY() + (double)(target.getBbHeight() * 0.5f)), (double)target.getZ(), (int)50, (double)(target.getBbWidth() * 0.5f), (double)(target.getBbHeight() * 0.5f), (double)(target.getBbWidth() * 0.5f), (double)0.03, (boolean)false);
                                    EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)serverPlayer.level()), (Entity)target, (DamageSource)this.getDamageSource((Entity)serverPlayer));
                                    DiscerningTheEldritch.LOGGER.debug("Bonus damage: " + extraDamage);
                                }
                            }
                        } else if (serverPlayer.getMainHandItem().is(DTETags.FROZEN_WEAPONS)) {
                            if (DamageSources.applyDamage((Entity)target, (float)(baseDamage * 1.5f), (DamageSource)this.getDamageSource((Entity)serverPlayer))) {
                                MagicManager.spawnParticles((Level)serverPlayer.level(), (ParticleOptions)ParticleHelper.SNOWFLAKE, (double)target.getX(), (double)(target.getY() + (double)(target.getBbHeight() * 0.5f)), (double)target.getZ(), (int)50, (double)(target.getBbWidth() * 0.5f), (double)(target.getBbHeight() * 0.5f), (double)(target.getBbWidth() * 0.5f), (double)0.03, (boolean)false);
                                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)serverPlayer.level()), (Entity)target, (DamageSource)this.getDamageSource((Entity)serverPlayer));
                                DiscerningTheEldritch.LOGGER.debug("Base damage (in living.hasEffect() (Icy)): " + baseDamage);
                            }
                        } else if (DamageSources.applyDamage((Entity)target, (float)baseDamage, (DamageSource)this.getDamageSource((Entity)serverPlayer))) {
                            MagicManager.spawnParticles((Level)serverPlayer.level(), (ParticleOptions)ParticleHelper.SNOWFLAKE, (double)target.getX(), (double)(target.getY() + (double)(target.getBbHeight() * 0.5f)), (double)target.getZ(), (int)50, (double)(target.getBbWidth() * 0.5f), (double)(target.getBbHeight() * 0.5f), (double)(target.getBbWidth() * 0.5f), (double)0.03, (boolean)false);
                            EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)serverPlayer.level()), (Entity)target, (DamageSource)this.getDamageSource((Entity)serverPlayer));
                            DiscerningTheEldritch.LOGGER.debug("Base damage (in living.hasEffect()): " + baseDamage);
                        }
                    } else if (DamageSources.applyDamage((Entity)target, (float)baseDamage, (DamageSource)this.getDamageSource((Entity)serverPlayer))) {
                        MagicManager.spawnParticles((Level)serverPlayer.level(), (ParticleOptions)ParticleHelper.SNOWFLAKE, (double)target.getX(), (double)(target.getY() + (double)(target.getBbHeight() * 0.5f)), (double)target.getZ(), (int)50, (double)(target.getBbWidth() * 0.5f), (double)(target.getBbHeight() * 0.5f), (double)(target.getBbWidth() * 0.5f), (double)0.03, (boolean)false);
                        EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)serverPlayer.level()), (Entity)target, (DamageSource)this.getDamageSource((Entity)serverPlayer));
                        DiscerningTheEldritch.LOGGER.debug("Base damage (outside): " + baseDamage);
                    }
                }
                target.setData(DTEAttachmentRegistry.FROSTBITE_LEVEL, (Object)0);
            }
            CrystalCarveEntity swipe = new CrystalCarveEntity(serverPlayer.level(), false);
            swipe.moveTo(hitLocation);
            swipe.setYRot(serverPlayer.getYRot());
            swipe.setIsFinal(true);
            serverPlayer.level().addFreshEntity((Entity)swipe);
        }
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = this.getSpellPower(spellLevel, (Entity)caster) * 0.5f;
        return baseDamage + this.getWeaponDamage(caster);
    }

    private float getWeaponDamage(LivingEntity caster) {
        float weaponDamage = Utils.getWeaponDamage((LivingEntity)caster);
        return weaponDamage;
    }

    private String getDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float weaponDamage = Utils.getWeaponDamage((LivingEntity)caster);
            String plus = "";
            if (weaponDamage > 0.0f) {
                plus = String.format(" (+%s)", Utils.stringTruncation((double)weaponDamage, (int)1));
            }
            String damage = Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1);
            return damage + plus;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }

    private MobEffectInstance getEffect(ArrayList<MobEffectInstance> effects, MobEffect mobEffect) {
        for (MobEffectInstance effect : effects) {
            if (!effect.getEffect().equals((Object)mobEffect)) continue;
            return effect;
        }
        return null;
    }
}

