/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dnejei.compat;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.moddata.ClientPlayerUnlockedEntries;
import com.cmdpro.datanessence.recipe.IHasRequiredKnowledge;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public abstract class UnlockableRecipeCategory<T>
extends AbstractRecipeCategory<T> {
    public static final Component lockedText1 = Component.translatable((String)"emi.datanessence.recipe_locked_line_1");
    public static final Component lockedText2 = Component.translatable((String)"emi.datanessence.recipe_locked_line_2");
    private final IDrawable background;

    public UnlockableRecipeCategory(IGuiHelper guiHelper, RecipeType<T> recipeType, Component title, IDrawable icon, int width, int height) {
        super(recipeType, title, icon, width, height);
        this.background = guiHelper.drawableBuilder(DataNEssence.locate((String)"textures/gui/emi_recipe_locked.png"), 0, 0, 123, 60).setTextureSize(256, 256).build();
    }

    abstract boolean isUnlocked(T var1);

    public boolean hasData(IHasRequiredKnowledge recipe) {
        return ClientPlayerUnlockedEntries.getUnlocked().contains(recipe.getEntry()) || ClientPlayerUnlockedEntries.getIncomplete().containsKey(recipe.getEntry()) && (Integer)ClientPlayerUnlockedEntries.getIncomplete().get(recipe.getEntry()) >= recipe.getCompletionStage();
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (this.isUnlocked(recipe)) {
            this.drawUnlocked(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        } else {
            this.background.draw(guiGraphics);
            guiGraphics.drawString(Minecraft.getInstance().font, Language.getInstance().getVisualOrder((FormattedText)lockedText1), 5, 30, -26955, false);
            guiGraphics.drawString(Minecraft.getInstance().font, Language.getInstance().getVisualOrder((FormattedText)lockedText2), 5, 40, -893279, false);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        if (this.isUnlocked(recipe)) {
            this.setUnlockedRecipe(builder, recipe, focuses);
        } else {
            this.setLockedRecipe(builder, recipe, focuses);
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, T recipe, IFocusGroup focuses) {
        if (this.isUnlocked(recipe)) {
            this.addUnlockedWidgets(builder, recipe, focuses);
        }
    }

    public abstract void drawUnlocked(T var1, IRecipeSlotsView var2, GuiGraphics var3, double var4, double var6);

    public abstract void setUnlockedRecipe(IRecipeLayoutBuilder var1, T var2, IFocusGroup var3);

    public abstract void setLockedRecipe(IRecipeLayoutBuilder var1, T var2, IFocusGroup var3);

    public abstract void addUnlockedWidgets(IRecipeExtrasBuilder var1, T var2, IFocusGroup var3);
}

