/*
 * Decompiled with CFR 0.152.
 */
package net.Iceforkkk.DreamlessAditions.registries;

import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.Iceforkkk.DreamlessAditions.Dreamless_Spells;
import net.Iceforkkk.DreamlessAditions.registries.DSSItems;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DSSArmorMaterials {
    private static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"dreamless_spells");
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> SOLAR_MATERIAL = DSSArmorMaterials.register("solar", DSSArmorMaterials.AdvancedArmorMap(), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_INGOT.get()}), 0.0f, 0.0f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> VORTEX_MATERIAL = DSSArmorMaterials.register("vortex", DSSArmorMaterials.AdvancedArmorMap(), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MITHRIL_INGOT.get()}), 0.0f, 0.0f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> EMPTY_PRIEST_MATERIAL = DSSArmorMaterials.register("empty_priest", DSSArmorMaterials.RegularArmorMap(), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)DSSItems.TUNGSTENINGOT.get()}), 0.0f, 0.0f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> EMPTY_BRAWLER_MATERIAL = DSSArmorMaterials.register("empty_brawler", DSSArmorMaterials.AdvancedArmorMap(), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)DSSItems.TUNGSTENINGOT.get()}), 2.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> EMPTY_HUNTER_MATERIAL = DSSArmorMaterials.register("empty_hunter", DSSArmorMaterials.AdvancedArmorMap(), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)DSSItems.TUNGSTENINGOT.get()}), 2.0f, 0.0f);

    private static DeferredHolder<ArmorMaterial, ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient, float toughness, float knockbackResistance) {
        List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(Dreamless_Spells.id(name)));
        return ARMOR_MATERIALS.register(name, () -> new ArmorMaterial((Map)defense, enchantmentValue, equipSound, repairIngredient, list, toughness, knockbackResistance));
    }

    private static EnumMap<ArmorItem.Type, Integer> makeArmorMap(int helmet, int chestplate, int leggings, int boots) {
        return (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.HELMET, helmet);
            map.put(ArmorItem.Type.CHESTPLATE, chestplate);
            map.put(ArmorItem.Type.LEGGINGS, leggings);
            map.put(ArmorItem.Type.BOOTS, boots);
        });
    }

    public static EnumMap<ArmorItem.Type, Integer> AdvancedArmorMap() {
        return DSSArmorMaterials.makeArmorMap(5, 11, 9, 5);
    }

    public static EnumMap<ArmorItem.Type, Integer> RegularArmorMap() {
        return DSSArmorMaterials.makeArmorMap(3, 8, 6, 3);
    }

    public static void register(IEventBus eventBus) {
        ARMOR_MATERIALS.register(eventBus);
    }
}

