/*
 * Decompiled with CFR 0.152.
 */
package net.Iceforkkk.DreamlessAditions.spells.empty;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.TargetedTargetAreaCastData;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.Iceforkkk.DreamlessAditions.effect.DSSEffects;
import net.Iceforkkk.DreamlessAditions.registries.DSSSchoolRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class DrainedSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"dreamless_spells", (String)"drained");
    private static final int MAX_TARGETS = 5;
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(DSSSchoolRegistry.EMPTY_RESOURCE).setMaxLevel(3).setCooldownSeconds(180.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)(this.getSpellPower(spellLevel, (Entity)caster) * 40.0f), (int)1)}), Component.translatable((String)"ui.irons_spellbooks.max_victims", (Object[])new Object[]{5}));
    }

    public DrainedSpell() {
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 5;
        this.castTime = 30;
        this.baseManaCost = 0;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.NATURE_CAST.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        if (!entity.hasEffect(DSSEffects.EMPTIED_EFFECT)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"ui.dreamless_spells.unforsaken_status", (Object[])new Object[]{this.getDisplayName((Player)serverPlayer)}).withStyle(ChatFormatting.RED)));
            }
            return false;
        }
        if (Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)32, (float)0.35f)) {
            float radius = 3.0f;
            assert (playerMagicData.getAdditionalCastData() != null);
            LivingEntity target = ((TargetEntityCastData)playerMagicData.getAdditionalCastData()).getTarget((ServerLevel)level);
            assert (target != null);
            TargetedAreaEntity area = TargetedAreaEntity.createTargetAreaEntity((Level)level, (Vec3)target.position(), (float)radius, (int)((MobEffect)MobEffectRegistry.SLOWED.get()).getColor(), (Entity)target);
            playerMagicData.setAdditionalCastData((ICastData)new TargetedTargetAreaCastData(target, area));
            return true;
        }
        return false;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (entity.hasEffect(DSSEffects.EMPTIED_EFFECT)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"ui.dreamless_spells.forsaken_status", (Object[])new Object[]{this.getDisplayName((Player)serverPlayer)}).withStyle(ChatFormatting.RED)));
                ICastData iCastData = playerMagicData.getAdditionalCastData();
                if (iCastData instanceof TargetedTargetAreaCastData) {
                    TargetedTargetAreaCastData targetData = (TargetedTargetAreaCastData)iCastData;
                    LivingEntity targetEntity = targetData.getTarget((ServerLevel)world);
                    if (targetEntity != null) {
                        float f = 3.0f;
                    }
                    AtomicInteger targets = new AtomicInteger(0);
                    assert (targetEntity != null);
                    targetEntity.level().getEntitiesOfClass(LivingEntity.class, targetEntity.getBoundingBox().inflate(2.0)).forEach(victim -> {
                        if (targets.get() < 5 && victim != entity && victim.distanceToSqr((Entity)targetEntity) < 4.0 && !DamageSources.isFriendlyFireBetween((Entity)entity, (Entity)victim)) {
                            victim.addEffect(new MobEffectInstance(DSSEffects.DRAINED_EFFECT, (int)(this.getSpellPower(spellLevel, (Entity)entity) * 40.0f), spellLevel - 1, false, false, true));
                        }
                    });
                }
            }
        } else if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"ui.dreamless_spells.unforsaken_status", (Object[])new Object[]{this.getDisplayName((Player)serverPlayer)}).withStyle(ChatFormatting.RED)));
        }
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ANIMATION_LONG_CAST;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.ANIMATION_LONG_CAST_FINISH;
    }
}

