/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.raw.ZombieRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Zombie;

public class ZombieRawRenderer
extends ZombieRenderer {
    protected static final Map<ZombieRaw.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.make(new EnumMap(ZombieRaw.Variant.class), map -> {
        map.put(ZombieRaw.Variant.DROWNED, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie/drowned.png"));
        map.put(ZombieRaw.Variant.HUSK, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie/husk.png"));
        map.put(ZombieRaw.Variant.ZOMBIE, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie/zombie.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)ZombieRaw.Variant.ZOMBIE);

    public ZombieRawRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(Zombie zombie) {
        if (zombie instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)zombie;
            return this.getEntityTexture(easyNPC);
        }
        return super.getTextureLocation(zombie);
    }

    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    public ResourceLocation getCustomTexture(SkinData<?> entity) {
        return CustomTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    public ResourceLocation getRemoteTexture(SkinData<?> entity) {
        return RemoteTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    public ResourceLocation getTextureByVariant(Enum<?> variant) {
        return TEXTURE_BY_VARIANT != null ? TEXTURE_BY_VARIANT.getOrDefault(variant, DEFAULT_TEXTURE) : Constants.BLANK_ENTITY_TEXTURE;
    }

    public <N extends EasyNPC<?>> ResourceLocation getEntityTexture(N easyNPC) {
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getVariant());
        };
    }
}

