/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.model.standard.StandardZombieVillagerModel;
import de.markusbordihn.easynpc.client.renderer.EasyNPCModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseHumanoidMobModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.layers.ProfessionLayer;
import de.markusbordihn.easynpc.client.renderer.entity.layers.VariantLayer;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.entity.easynpc.npc.ZombieVillager;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class ZombieVillagerModelRenderer
extends BaseHumanoidMobModelRenderer<ZombieVillager, ZombieVillager.Variant, StandardZombieVillagerModel<ZombieVillager>> {
    public static final ResourceLocation BASE_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/zombie_villager.png");
    protected static final Map<Profession, ResourceLocation> TEXTURE_BY_PROFESSION = (Map)Util.make(new EnumMap(Profession.class), map -> {
        map.put(Profession.NONE, Constants.BLANK_ENTITY_TEXTURE);
        map.put(Profession.ARMORER, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/armorer.png"));
        map.put(Profession.BUTCHER, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/butcher.png"));
        map.put(Profession.CARTOGRAPHER, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/cartographer.png"));
        map.put(Profession.CLERIC, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/cleric.png"));
        map.put(Profession.FARMER, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/farmer.png"));
        map.put(Profession.FISHERMAN, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/fisherman.png"));
        map.put(Profession.FLETCHER, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/fletcher.png"));
        map.put(Profession.LEATHERWORKER, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/leatherworker.png"));
        map.put(Profession.LIBRARIAN, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/librarian.png"));
        map.put(Profession.MASON, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/mason.png"));
        map.put(Profession.NITWIT, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/nitwit.png"));
        map.put(Profession.SHEPHERD, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/shepherd.png"));
        map.put(Profession.TOOLSMITH, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/toolsmith.png"));
        map.put(Profession.WEAPONSMITH, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/profession/weaponsmith.png"));
    });
    protected static final Map<ZombieVillager.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.make(new EnumMap(ZombieVillager.Variant.class), map -> {
        map.put(ZombieVillager.Variant.DEFAULT, Constants.BLANK_ENTITY_TEXTURE);
        map.put(ZombieVillager.Variant.DESERT, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/type/desert.png"));
        map.put(ZombieVillager.Variant.JUNGLE, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/type/jungle.png"));
        map.put(ZombieVillager.Variant.PLAINS, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/type/plains.png"));
        map.put(ZombieVillager.Variant.SAVANNA, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/type/savanna.png"));
        map.put(ZombieVillager.Variant.SNOW, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/type/snow.png"));
        map.put(ZombieVillager.Variant.SWAMP, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/type/swamp.png"));
        map.put(ZombieVillager.Variant.TAIGA, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie_villager/type/taiga.png"));
    });

    public <L extends RenderLayer<ZombieVillager, StandardZombieVillagerModel<ZombieVillager>>> ZombieVillagerModelRenderer(EntityRendererProvider.Context context, Class<L> humanoidArmorLayerClass) {
        super(context, new StandardZombieVillagerModel(context.bakeLayer(ModelLayers.ZOMBIE_VILLAGER)), 0.5f, BASE_TEXTURE);
        this.addLayer((RenderLayer)EasyNPCModelRenderer.getHumanoidArmorLayer(this, context, ModelLayers.ZOMBIE_VILLAGER_INNER_ARMOR, ModelLayers.ZOMBIE_VILLAGER_OUTER_ARMOR, humanoidArmorLayerClass));
        this.addLayer(new VariantLayer(this, context.getModelSet(), TEXTURE_BY_VARIANT));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer(new ProfessionLayer(this, context.getModelSet(), TEXTURE_BY_PROFESSION));
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variant) {
        return BASE_TEXTURE;
    }

    @Override
    public void renderDefaultPose(ZombieVillager entity, StandardZombieVillagerModel<ZombieVillager> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.translate(-1.0, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees((LivingEntity)entity)));
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                model.getHead().xRot = -0.7853982f;
                model.getHead().yRot = -0.7853982f;
                model.getHead().zRot = -0.7853982f;
                break;
            }
            case SLEEPING: {
                poseStack.translate(1.0, 0.0, 0.0);
                break;
            }
            default: {
                model.getHead().xRot = 0.0f;
                model.getHead().yRot = 0.0f;
                model.getHead().zRot = 0.0f;
            }
        }
    }
}

