/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.manager;

import de.markusbordihn.easynpc.compat.CompatConstants;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RendererManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String LOG_PREFIX = "[Renderer Manager]";
    private static final Map<EntityType<? extends Entity>, EntityRenderer<? extends Entity>> entityRendererMap = new HashMap<EntityType<? extends Entity>, EntityRenderer<? extends Entity>>();
    private static final Map<EntityType<? extends Entity>, LivingEntityRenderer<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>>> livingEntityRendererMap = new HashMap<EntityType<? extends Entity>, LivingEntityRenderer<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>>>();

    private RendererManager() {
    }

    public static LivingEntityRenderer<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> getLivingEntityRenderer(EntityType<? extends Entity> entityType, PathfinderMob pathfinderMob) {
        if (entityType == null || pathfinderMob == null) {
            return null;
        }
        LivingEntityRenderer<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> livingEntityRenderer = livingEntityRendererMap.get(entityType);
        if (livingEntityRenderer != null) {
            return livingEntityRenderer;
        }
        RendererManager.registerLivingEntityRenderer(entityType, pathfinderMob);
        return livingEntityRendererMap.get(entityType);
    }

    public static EntityRenderer<? extends Entity> getEntityRenderer(EntityType<?> entityType, PathfinderMob pathfinderMob) {
        if (entityType == null || pathfinderMob == null) {
            return null;
        }
        EntityRenderer<? extends Entity> entityRenderer = entityRendererMap.get(entityType);
        if (entityRenderer != null) {
            return entityRenderer;
        }
        RendererManager.registerEntityRenderer(entityType, pathfinderMob);
        return entityRendererMap.get(entityType);
    }

    public static LivingEntityRenderer<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> registerLivingEntityRenderer(EntityType<? extends Entity> entityType, PathfinderMob pathfinderMob) {
        if (entityType == null || pathfinderMob == null) {
            return null;
        }
        if (livingEntityRendererMap.containsKey(entityType)) {
            return livingEntityRendererMap.get(entityType);
        }
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityRenderer = entityRenderDispatcher.getRenderer((Entity)pathfinderMob);
        if (entityRenderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)entityRenderer;
            log.debug("{} Registering living entity renderer {} for {}", (Object)LOG_PREFIX, (Object)livingEntityRenderer, entityType);
            livingEntityRendererMap.put(entityType, (LivingEntityRenderer<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>>)livingEntityRenderer);
            return livingEntityRenderer;
        }
        if (!entityRendererMap.containsKey(entityType)) {
            log.debug("{} Registering entity renderer {} for {}", (Object)LOG_PREFIX, (Object)entityRenderer, entityType);
            entityRendererMap.put(entityType, (EntityRenderer<? extends Entity>)entityRenderer);
        }
        return null;
    }

    public static EntityRenderer<? extends Entity> registerEntityRenderer(EntityType<? extends Entity> entityType, PathfinderMob pathfinderMob) {
        if (entityType == null || pathfinderMob == null) {
            return null;
        }
        if (entityRendererMap.containsKey(entityType)) {
            return entityRendererMap.get(entityType);
        }
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityRenderer = entityRenderDispatcher.getRenderer((Entity)pathfinderMob);
        log.debug("{} Registering entity renderer {} for {}", (Object)LOG_PREFIX, (Object)entityRenderer, entityType);
        entityRendererMap.put(entityType, (EntityRenderer<? extends Entity>)entityRenderer);
        return entityRenderer;
    }

    public static void copyModSpecificData(PathfinderMob sourceEntity, Entity targetEntity, String entityTypeName) {
        if (sourceEntity == null || targetEntity == null || entityTypeName == null || sourceEntity == targetEntity) {
            return;
        }
        if (!CompatConstants.MOD_COBBLEMON_LOADED || entityTypeName.equals("cobblemon:pokemon")) {
            // empty if block
        }
    }

    public static void copyCustomEntityData(PathfinderMob sourceEntity, Entity targetEntity, String entityTypeName) {
        if (sourceEntity == null || targetEntity == null || entityTypeName == null || sourceEntity == targetEntity) {
            return;
        }
        RendererManager.copyModSpecificData(sourceEntity, targetEntity, entityTypeName);
        targetEntity.tickCount = sourceEntity.tickCount;
        targetEntity.setYRot(sourceEntity.getYRot());
        targetEntity.yRotO = sourceEntity.yRotO;
        targetEntity.setXRot(sourceEntity.getXRot());
        targetEntity.xRotO = sourceEntity.xRotO;
        targetEntity.setYHeadRot(sourceEntity.getYHeadRot());
        targetEntity.setYBodyRot(sourceEntity.yBodyRot);
        targetEntity.setPos(sourceEntity.getX(), sourceEntity.getY(), sourceEntity.getZ());
        targetEntity.setOnGround(sourceEntity.onGround());
        targetEntity.setDeltaMovement(sourceEntity.getDeltaMovement());
        if (sourceEntity.hasCustomName()) {
            targetEntity.setCustomName(sourceEntity.getCustomName());
            targetEntity.setCustomNameVisible(sourceEntity.isCustomNameVisible());
        }
        if (sourceEntity.getPose() != targetEntity.getPose()) {
            targetEntity.setPose(sourceEntity.getPose());
        }
    }

    public static void copyCustomLivingEntityData(PathfinderMob sourceEntity, LivingEntity targetEntity, String entityTypeName) {
        if (sourceEntity == null || targetEntity == null || entityTypeName == null || sourceEntity == targetEntity) {
            return;
        }
        RendererManager.copyCustomEntityData(sourceEntity, (Entity)targetEntity, entityTypeName);
        targetEntity.yHeadRotO = sourceEntity.yHeadRotO;
        targetEntity.yBodyRotO = sourceEntity.yBodyRotO;
        targetEntity.attackAnim = sourceEntity.attackAnim;
        targetEntity.oAttackAnim = sourceEntity.oAttackAnim;
        if (!sourceEntity.getMainHandItem().isEmpty()) {
            targetEntity.setItemInHand(InteractionHand.MAIN_HAND, sourceEntity.getMainHandItem());
        }
        if (!sourceEntity.getOffhandItem().isEmpty()) {
            targetEntity.setItemInHand(InteractionHand.OFF_HAND, sourceEntity.getOffhandItem());
        }
    }
}

