/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.attribute;

import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.attribute.AttributeConfigurationScreen;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Inventory;

public class BaseAttributeConfigurationScreen<T extends ConfigurationMenu>
extends AttributeConfigurationScreen<T> {
    RangeSliderButton armorSlider;
    RangeSliderButton armorToughnessSlider;
    RangeSliderButton attackDamageSlider;
    RangeSliderButton attackKnockbackSlider;
    RangeSliderButton attackSpeedSlider;
    RangeSliderButton flyingSpeedSlider;
    RangeSliderButton followRangeSlider;
    RangeSliderButton knockbackResistanceSlider;
    RangeSliderButton maxHealthSlider;
    RangeSliderButton movementSpeedSlider;

    public BaseAttributeConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    protected RangeSliderButton createAttributeSlider(int left, int top, int width, int height, Attribute attribute, double value, double defaultMinValue, double defaultMaxValue, double defaultValue, double stepSize, SliderButton.OnChange onChange) {
        double d;
        double minValue;
        if (attribute instanceof RangedAttribute) {
            RangedAttribute rangedAttribute = (RangedAttribute)attribute;
            v0 = rangedAttribute.getMinValue();
        } else {
            v0 = minValue = defaultMinValue;
        }
        if (attribute instanceof RangedAttribute) {
            RangedAttribute rangedAttribute = (RangedAttribute)attribute;
            d = rangedAttribute.getMaxValue();
        } else {
            d = defaultMaxValue;
        }
        double maxValue = d;
        return (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(left, top, width, height, attribute.getDescriptionId(), value, minValue, maxValue, defaultValue, stepSize, onChange));
    }

    @Override
    public void init() {
        super.init();
        this.baseAttributeButton.active = false;
        int sliderXPos = this.buttonLeftPos + 130;
        int sliderYPos = this.buttonTopPos + 22;
        int sliderWidth = 170;
        int sliderHeight = 14;
        int sliderYSpace = 20;
        LivingEntity livingEntity = this.getEasyNPC().getLivingEntity();
        this.maxHealthSlider = this.createAttributeSlider(sliderXPos, sliderYPos, sliderWidth, sliderHeight, (Attribute)Attributes.MAX_HEALTH.value(), livingEntity.getAttributeBaseValue(Attributes.MAX_HEALTH), 1.0, 1024.0, 20.0, 1.0, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), (Attribute)Attributes.MAX_HEALTH.value(), slider.getTargetDoubleValue()));
        this.followRangeSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, (Attribute)Attributes.FOLLOW_RANGE.value(), this.getBaseAttributes().getFollowRange(), 0.0, 2048.0, 32.0, 1.0, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), (Attribute)Attributes.FOLLOW_RANGE.value(), slider.getTargetDoubleValue()));
        this.knockbackResistanceSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, (Attribute)Attributes.KNOCKBACK_RESISTANCE.value(), this.getBaseAttributes().getKnockbackResistance(), 0.0, 1.0, 0.0, 0.1, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), (Attribute)Attributes.KNOCKBACK_RESISTANCE.value(), slider.getTargetDoubleValue()));
        if (livingEntity.getAttribute(Attributes.MOVEMENT_SPEED) != null) {
            this.movementSpeedSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, (Attribute)Attributes.MOVEMENT_SPEED.value(), livingEntity.getAttributeBaseValue(Attributes.MOVEMENT_SPEED), 0.0, 2.0, 0.6, 0.1, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), (Attribute)Attributes.MOVEMENT_SPEED.value(), slider.getTargetDoubleValue()));
        }
        if (livingEntity.getAttribute(Attributes.FLYING_SPEED) != null) {
            this.flyingSpeedSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, (Attribute)Attributes.FLYING_SPEED.value(), livingEntity.getAttributeBaseValue(Attributes.FLYING_SPEED), 0.0, 2.0, 0.4, 0.1, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), (Attribute)Attributes.FLYING_SPEED.value(), slider.getTargetDoubleValue()));
        }
        this.attackDamageSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, (Attribute)Attributes.ATTACK_DAMAGE.value(), this.getBaseAttributes().getAttackDamage(), 0.0, 2048.0, 2.0, 1.0, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), (Attribute)Attributes.ATTACK_DAMAGE.value(), slider.getTargetDoubleValue()));
        this.attackKnockbackSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, (Attribute)Attributes.ATTACK_KNOCKBACK.value(), this.getBaseAttributes().getAttackKnockback(), 0.0, 5.0, 0.0, 0.1, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), (Attribute)Attributes.ATTACK_KNOCKBACK.value(), slider.getTargetDoubleValue()));
        if (livingEntity.getAttribute(Attributes.ATTACK_SPEED) != null) {
            this.attackSpeedSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, (Attribute)Attributes.ATTACK_SPEED.value(), livingEntity.getAttributeBaseValue(Attributes.ATTACK_SPEED), 0.0, 1024.0, 4.0, 0.5, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), (Attribute)Attributes.ATTACK_SPEED.value(), slider.getTargetDoubleValue()));
        }
        this.armorSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, (Attribute)Attributes.ARMOR.value(), livingEntity.getAttributeBaseValue(Attributes.ARMOR), 0.0, 30.0, 0.0, 1.0, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), (Attribute)Attributes.ARMOR.value(), slider.getTargetDoubleValue()));
        this.armorToughnessSlider = this.createAttributeSlider(sliderXPos, sliderYPos += sliderYSpace, sliderWidth, sliderHeight, (Attribute)Attributes.ARMOR_TOUGHNESS.value(), livingEntity.getAttributeBaseValue(Attributes.ARMOR_TOUGHNESS), 0.0, 20.0, 0.0, 0.5, slider -> NetworkMessageHandlerManager.getServerHandler().entityBaseAttributeChange(this.getEasyNPCUUID(), (Attribute)Attributes.ARMOR_TOUGHNESS.value(), slider.getTargetDoubleValue()));
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        int sliderXOffset = -135;
        int sliderYOffset = 3;
        if (this.maxHealthSlider != null) {
            Text.drawConfigString(guiGraphics, this.font, "max_health", this.maxHealthSlider.getX() + sliderXOffset, this.maxHealthSlider.getY() + sliderYOffset);
        }
        if (this.followRangeSlider != null) {
            Text.drawConfigString(guiGraphics, this.font, "follow_range", this.followRangeSlider.getX() + sliderXOffset, this.followRangeSlider.getY() + sliderYOffset);
        }
        if (this.knockbackResistanceSlider != null) {
            Text.drawConfigString(guiGraphics, this.font, "knockback_resistance", this.knockbackResistanceSlider.getX() + sliderXOffset, this.knockbackResistanceSlider.getY() + sliderYOffset);
        }
        if (this.movementSpeedSlider != null) {
            Text.drawConfigString(guiGraphics, this.font, "movement_speed", this.movementSpeedSlider.getX() + sliderXOffset, this.movementSpeedSlider.getY() + sliderYOffset);
        }
        if (this.flyingSpeedSlider != null) {
            Text.drawConfigString(guiGraphics, this.font, "flying_speed", this.flyingSpeedSlider.getX() + sliderXOffset, this.flyingSpeedSlider.getY() + sliderYOffset);
        }
        if (this.attackDamageSlider != null) {
            Text.drawConfigString(guiGraphics, this.font, "attack_damage", this.attackDamageSlider.getX() + sliderXOffset, this.attackDamageSlider.getY() + sliderYOffset);
        }
        if (this.attackKnockbackSlider != null) {
            Text.drawConfigString(guiGraphics, this.font, "attack_knockback", this.attackKnockbackSlider.getX() + sliderXOffset, this.attackKnockbackSlider.getY() + sliderYOffset);
        }
        if (this.attackSpeedSlider != null) {
            Text.drawConfigString(guiGraphics, this.font, "attack_speed", this.attackSpeedSlider.getX() + sliderXOffset, this.attackSpeedSlider.getY() + sliderYOffset);
        }
        if (this.armorSlider != null) {
            Text.drawConfigString(guiGraphics, this.font, "armor", this.armorSlider.getX() + sliderXOffset, this.armorSlider.getY() + sliderYOffset);
        }
        if (this.armorToughnessSlider != null) {
            Text.drawConfigString(guiGraphics, this.font, "armor_toughness", this.armorToughnessSlider.getX() + sliderXOffset, this.armorToughnessSlider.getY() + sliderYOffset);
        }
    }
}

