/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.objective;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.objective.ObjectiveConfigurationScreen;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class LookObjectiveConfigurationScreen<T extends ConfigurationMenu>
extends ObjectiveConfigurationScreen<T> {
    protected Checkbox lookResetCheckbox;
    protected Checkbox randomLookAroundCheckbox;
    protected Checkbox lookAtOwnerCheckbox;
    protected Checkbox lookAtPlayerCheckbox;
    protected Checkbox lookAtMobCheckbox;
    protected Checkbox lookAtAnimalCheckbox;
    protected Checkbox lookAtEntityCheckbox;
    protected EditBox lookAtEntityUUID;
    protected Button lookAtEntityUUIDSaveButton;

    public LookObjectiveConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void init() {
        super.init();
        this.lookObjectiveButton.active = false;
        int objectiveEntriesTop = this.contentTopPos + 5;
        int objectiveEntriesFirstColumn = this.contentLeftPos + 5;
        int objectiveEntriesSecondColumn = this.contentLeftPos + 145;
        this.lookResetCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)this.getObjectiveCheckbox(objectiveEntriesFirstColumn, objectiveEntriesTop, ObjectiveType.LOOK_AT_RESET));
        this.randomLookAroundCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)this.getObjectiveCheckbox(objectiveEntriesFirstColumn, objectiveEntriesTop += 20, ObjectiveType.LOOK_RANDOM_AROUND));
        OwnerData ownerData = this.getOwnerData();
        this.lookAtOwnerCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)new Checkbox(objectiveEntriesFirstColumn, objectiveEntriesTop += 20, ObjectiveType.LOOK_AT_OWNER.getObjectiveName(), ownerData.getOwnerName(), this.objectiveDataSet.hasObjective(ObjectiveType.LOOK_AT_OWNER), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.LOOK_AT_OWNER, 9);
            objectiveDataEntry.setTargetOwnerUUID(ownerData.getOwnerUUID());
            if (checkbox.selected()) {
                NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            } else {
                NetworkMessageHandlerManager.getServerHandler().removeObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            }
        }));
        this.lookAtOwnerCheckbox.active = false;
        this.lookAtPlayerCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)this.getObjectiveCheckbox(objectiveEntriesFirstColumn, objectiveEntriesTop += 20, ObjectiveType.LOOK_AT_PLAYER));
        this.lookAtMobCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)this.getObjectiveCheckbox(objectiveEntriesFirstColumn, objectiveEntriesTop += 20, ObjectiveType.LOOK_AT_MOB));
        this.lookAtAnimalCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)this.getObjectiveCheckbox(objectiveEntriesFirstColumn, objectiveEntriesTop += 20, ObjectiveType.LOOK_AT_ANIMAL));
        this.lookAtEntityCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)new Checkbox(objectiveEntriesFirstColumn, objectiveEntriesTop += 20, ObjectiveType.LOOK_AT_ENTITY_BY_UUID.getObjectiveName(), this.objectiveDataSet.hasObjective(ObjectiveType.LOOK_AT_ENTITY_BY_UUID), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.LOOK_AT_ENTITY_BY_UUID, 9);
            if (this.lookAtEntityUUID != null) {
                if (!this.lookAtEntityUUID.getValue().isEmpty()) {
                    UUID entityUUID = null;
                    try {
                        entityUUID = UUID.fromString(this.lookAtEntityUUID.getValue());
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Unable to parse UUID {} for {}", (Object)this.lookAtEntityUUID.getValue(), (Object)this.getEasyNPCUUID());
                    }
                    if (entityUUID != null) {
                        objectiveDataEntry.setTargetEntityUUID(entityUUID);
                    }
                }
                this.lookAtEntityUUID.setEditable(checkbox.selected());
            }
            if (this.lookAtEntityUUIDSaveButton != null) {
                this.lookAtEntityUUIDSaveButton.active = checkbox.selected();
            }
            if (!checkbox.selected()) {
                NetworkMessageHandlerManager.getServerHandler().removeObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            } else if (!this.lookAtEntityUUID.getValue().isEmpty()) {
                NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            }
        }));
        this.lookAtEntityCheckbox.active = false;
        this.lookAtEntityUUID = (EditBox)this.addRenderableWidget((GuiEventListener)new TextField(this.font, objectiveEntriesSecondColumn, objectiveEntriesTop, 115));
        this.lookAtEntityUUID.setMaxLength(36);
        this.lookAtEntityUUID.setEditable(this.objectiveDataSet.hasObjective(ObjectiveType.LOOK_AT_ENTITY_BY_UUID));
        this.lookAtEntityUUID.setResponder(value -> {
            if (this.lookAtEntityUUIDSaveButton != null) {
                this.lookAtEntityUUIDSaveButton.active = value != null && !value.isEmpty();
            }
        });
        this.lookAtEntityUUID.setValue(this.objectiveDataSet.hasObjective(ObjectiveType.LOOK_AT_ENTITY_BY_UUID) && this.objectiveDataSet.getObjective(ObjectiveType.LOOK_AT_ENTITY_BY_UUID).getTargetEntityUUID() != null ? this.objectiveDataSet.getObjective(ObjectiveType.LOOK_AT_ENTITY_BY_UUID).getTargetEntityUUID().toString() : "");
        this.lookAtEntityUUID.active = false;
        this.lookAtEntityUUIDSaveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.lookAtEntityUUID.getX() + this.lookAtEntityUUID.getWidth() + 5, objectiveEntriesTop - 1, onPress -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.LOOK_AT_ENTITY_BY_UUID, 9);
            objectiveDataEntry.setTargetEntityUUID(!this.lookAtEntityUUID.getValue().isEmpty() ? UUID.fromString(this.lookAtEntityUUID.getValue()) : null);
            NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
        }));
        this.lookAtEntityUUIDSaveButton.active = false;
    }
}

