/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.spawner;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.PositiveNumberField;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.data.spawner.SpawnerSettingType;
import de.markusbordihn.easynpc.menu.spawner.SpawnerMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnerScreen<T extends SpawnerMenu>
extends AbstractContainerScreen<T> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String SPAWNER_PREFIX = "spawner.";
    private final SpawnerMenu spawnerMenu;
    private EditBox delayEdit;
    private Button delaySaveButton;
    private EditBox maxNearbyEntitiesEdit;
    private Button maxNearbyEntitiesSaveButton;
    private EditBox requiredPlayerRangeEdit;
    private Button requiredPlayerRangeSaveButton;
    private EditBox spawnCountEdit;
    private Button spawnCountSaveButton;
    private EditBox spawnerDespawnRangeEdit;
    private Button spawnerDespawnRangeSaveButton;
    private EditBox spawnerRangeEdit;
    private Button spawnerRangeSaveButton;
    private boolean updatedDataFields = false;

    public SpawnerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.spawnerMenu = menu;
    }

    public void init() {
        super.init();
        this.imageHeight = 243;
        this.imageWidth = 260;
        this.topPos = (this.height - this.imageHeight) / 2 + 2;
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.inventoryLabelY = this.imageHeight - 92;
        int settingsLeft = this.leftPos + 196;
        int settingsTop = this.topPos + 20;
        int settingsWidth = 35;
        this.requiredPlayerRangeEdit = (EditBox)this.addRenderableWidget((GuiEventListener)new PositiveNumberField(this.font, settingsLeft, settingsTop, settingsWidth, this.spawnerMenu.getRequiredPlayerRange(), 3));
        this.requiredPlayerRangeEdit.setResponder(value -> {
            if (this.requiredPlayerRangeSaveButton != null) {
                this.requiredPlayerRangeSaveButton.active = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getRequiredPlayerRange();
            }
        });
        this.requiredPlayerRangeSaveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.requiredPlayerRangeEdit.getX() + this.requiredPlayerRangeEdit.getWidth() + 5, this.requiredPlayerRangeEdit.getY() - 1, button -> {
            if (this.requiredPlayerRangeEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.REQUIRED_PLAYER_RANGE, Integer.parseInt(this.requiredPlayerRangeEdit.getValue()));
                this.requiredPlayerRangeSaveButton.active = false;
            }
        }));
        this.delayEdit = (EditBox)this.addRenderableWidget((GuiEventListener)new PositiveNumberField(this.font, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getDelay(), 4));
        this.delayEdit.setResponder(value -> {
            if (this.delaySaveButton != null) {
                this.delaySaveButton.active = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getDelay();
            }
        });
        this.delaySaveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.delayEdit.getX() + this.delayEdit.getWidth() + 5, this.delayEdit.getY() - 1, button -> {
            if (this.delayEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.DELAY, Integer.parseInt(this.delayEdit.getValue()));
                this.delaySaveButton.active = false;
            }
        }));
        this.maxNearbyEntitiesEdit = (EditBox)this.addRenderableWidget((GuiEventListener)new PositiveNumberField(this.font, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getMaxNearbyEntities(), 2));
        this.maxNearbyEntitiesEdit.setResponder(value -> {
            if (this.maxNearbyEntitiesSaveButton != null) {
                this.maxNearbyEntitiesSaveButton.active = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getMaxNearbyEntities();
            }
        });
        this.maxNearbyEntitiesSaveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.maxNearbyEntitiesEdit.getX() + this.maxNearbyEntitiesEdit.getWidth() + 5, this.maxNearbyEntitiesEdit.getY() - 1, button -> {
            if (this.maxNearbyEntitiesEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.MAX_NEARBY_ENTITIES, Integer.parseInt(this.maxNearbyEntitiesEdit.getValue()));
                this.maxNearbyEntitiesSaveButton.active = false;
            }
        }));
        this.spawnCountEdit = (EditBox)this.addRenderableWidget((GuiEventListener)new PositiveNumberField(this.font, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getSpawnCount(), 3));
        this.spawnCountEdit.setResponder(value -> {
            if (this.spawnCountSaveButton != null) {
                this.spawnCountSaveButton.active = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getSpawnCount();
            }
        });
        this.spawnCountSaveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.spawnCountEdit.getX() + this.spawnCountEdit.getWidth() + 5, this.spawnCountEdit.getY() - 1, button -> {
            if (this.spawnCountEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.SPAWN_COUNT, Integer.parseInt(this.spawnCountEdit.getValue()));
                this.spawnCountSaveButton.active = false;
            }
        }));
        this.spawnerRangeEdit = (EditBox)this.addRenderableWidget((GuiEventListener)new PositiveNumberField(this.font, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getSpawnRange(), 3));
        this.spawnerRangeEdit.setResponder(value -> {
            if (this.spawnerRangeSaveButton != null && this.spawnerDespawnRangeEdit != null) {
                this.spawnerRangeSaveButton.active = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getSpawnRange() && Integer.parseInt(value) < Integer.parseInt(this.spawnerDespawnRangeEdit.getValue());
            }
        });
        this.spawnerRangeSaveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.spawnerRangeEdit.getX() + this.spawnerRangeEdit.getWidth() + 5, this.spawnerRangeEdit.getY() - 1, button -> {
            if (this.spawnerRangeEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.SPAWN_RANGE, Integer.parseInt(this.spawnerRangeEdit.getValue()));
                this.spawnerRangeSaveButton.active = false;
            }
        }));
        this.spawnerDespawnRangeEdit = (EditBox)this.addRenderableWidget((GuiEventListener)new PositiveNumberField(this.font, settingsLeft, settingsTop += 20, settingsWidth, this.spawnerMenu.getDespawnRange(), 3));
        this.spawnerDespawnRangeEdit.setResponder(value -> {
            if (this.spawnerDespawnRangeSaveButton != null && this.spawnerRangeEdit != null) {
                this.spawnerDespawnRangeSaveButton.active = value != null && !value.isEmpty() && Integer.parseInt(value) != this.spawnerMenu.getDespawnRange() && Integer.parseInt(value) > Integer.parseInt(this.spawnerRangeEdit.getValue());
            }
        });
        this.spawnerDespawnRangeSaveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.spawnerDespawnRangeEdit.getX() + this.spawnerDespawnRangeEdit.getWidth() + 5, this.spawnerDespawnRangeEdit.getY() - 1, button -> {
            if (this.spawnerDespawnRangeEdit != null) {
                this.changeSpawnerSetting(this.spawnerMenu.getSpawnerPosition(), SpawnerSettingType.DESPAWN_RANGE, Integer.parseInt(this.spawnerDespawnRangeEdit.getValue()));
                this.spawnerDespawnRangeSaveButton.active = false;
            }
        }));
    }

    protected void containerTick() {
        super.containerTick();
        if (!this.updatedDataFields) {
            this.updateDataFields();
            this.updatedDataFields = true;
        }
    }

    protected void updateDataFields() {
        if (this.spawnerRangeEdit != null) {
            this.spawnerRangeEdit.setValue(String.valueOf(this.spawnerMenu.getSpawnRange()));
        }
        if (this.spawnerDespawnRangeEdit != null) {
            this.spawnerDespawnRangeEdit.setValue(String.valueOf(this.spawnerMenu.getDespawnRange()));
        }
        if (this.requiredPlayerRangeEdit != null) {
            this.requiredPlayerRangeEdit.setValue(String.valueOf(this.spawnerMenu.getRequiredPlayerRange()));
        }
        if (this.delayEdit != null) {
            this.delayEdit.setValue(String.valueOf(this.spawnerMenu.getDelay()));
        }
        if (this.maxNearbyEntitiesEdit != null) {
            this.maxNearbyEntitiesEdit.setValue(String.valueOf(this.spawnerMenu.getMaxNearbyEntities()));
        }
        if (this.spawnCountEdit != null) {
            this.spawnCountEdit.setValue(String.valueOf(this.spawnerMenu.getSpawnCount()));
        }
    }

    protected void changeSpawnerSetting(BlockPos blockPos, SpawnerSettingType spawnerSettingType, int value) {
        NetworkMessageHandlerManager.getServerHandler().changeSpawnerSettings(blockPos, spawnerSettingType, value);
    }

    protected void renderLabels(GuiGraphics guiGraphics) {
        int labelOffsetX = -180;
        int labelOffsetY = 4;
        if (this.spawnerRangeEdit != null) {
            Text.drawConfigString(guiGraphics, this.font, SPAWNER_PREFIX + SpawnerSettingType.SPAWN_RANGE.name().toLowerCase(Locale.ROOT), this.spawnerRangeEdit.getX() + labelOffsetX, this.spawnerRangeEdit.getY() + labelOffsetY);
        }
        if (this.spawnerDespawnRangeEdit != null) {
            Text.drawConfigString(guiGraphics, this.font, SPAWNER_PREFIX + SpawnerSettingType.DESPAWN_RANGE.name().toLowerCase(Locale.ROOT), this.spawnerDespawnRangeEdit.getX() + labelOffsetX, this.spawnerDespawnRangeEdit.getY() + labelOffsetY);
        }
        if (this.requiredPlayerRangeEdit != null) {
            Text.drawConfigString(guiGraphics, this.font, SPAWNER_PREFIX + SpawnerSettingType.REQUIRED_PLAYER_RANGE.name().toLowerCase(Locale.ROOT), this.requiredPlayerRangeEdit.getX() + labelOffsetX, this.requiredPlayerRangeEdit.getY() + labelOffsetY);
        }
        if (this.delayEdit != null) {
            Text.drawConfigString(guiGraphics, this.font, SPAWNER_PREFIX + SpawnerSettingType.DELAY.name().toLowerCase(Locale.ROOT), this.delayEdit.getX() + labelOffsetX, this.delayEdit.getY() + labelOffsetY);
        }
        if (this.maxNearbyEntitiesEdit != null) {
            Text.drawConfigString(guiGraphics, this.font, SPAWNER_PREFIX + SpawnerSettingType.MAX_NEARBY_ENTITIES.name().toLowerCase(Locale.ROOT), this.maxNearbyEntitiesEdit.getX() + labelOffsetX, this.maxNearbyEntitiesEdit.getY() + labelOffsetY);
        }
        if (this.spawnCountEdit != null) {
            Text.drawConfigString(guiGraphics, this.font, SPAWNER_PREFIX + SpawnerSettingType.SPAWN_COUNT.name().toLowerCase(Locale.ROOT), this.spawnCountEdit.getX() + labelOffsetX, this.spawnCountEdit.getY() + labelOffsetY);
        }
        Text.drawConfigString(guiGraphics, this.font, "spawner.preset_item", this.leftPos + 42 - 20, this.topPos + 169 + 22, this.spawnerMenu.getPresetItem().isEmpty() ? 0xFF5555 : 0xAAAAAA);
    }

    public void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Text.drawString(guiGraphics, this.font, this.title, this.titleLabelX + 80, this.titleLabelY + 2, 0);
        Text.drawString(guiGraphics, this.font, "(" + this.spawnerMenu.getSpawnerPosition().toShortString() + ")", this.titleLabelX + 180, this.titleLabelY + 2, 0xAAAAAA);
        Text.drawString(guiGraphics, this.font, this.playerInventoryTitle, this.inventoryLabelX + 90, this.inventoryLabelY - 10, 0);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderLabels(guiGraphics);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos, this.topPos, 0, 0, 210, 160);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos + 153, this.topPos, 132, 0, 120, 160);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos, this.topPos + 77, 0, 5, 210, 170);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos + 153, this.topPos + 77, 132, 5, 120, 170);
        Graphics.blit(guiGraphics, Constants.TEXTURE_INVENTORY, this.leftPos + 97, this.topPos + 152, 7, 83, 162, 54);
        Graphics.blit(guiGraphics, Constants.TEXTURE_INVENTORY, this.leftPos + 97, this.topPos + 212, 7, 141, 162, 18);
        Graphics.blit(guiGraphics, Constants.TEXTURE_INVENTORY, this.leftPos + 42 - 1, this.topPos + 169 - 1, 76, 61, 18, 18);
        if (this.spawnerMenu.getPresetItem().isEmpty()) {
            Graphics.blit(guiGraphics, Constants.TEXTURE_SPAWNER, this.leftPos + 42 + 20, this.topPos + 169 + 2, 0, 0, 32, 12);
            Graphics.blit(guiGraphics, Constants.TEXTURE_SPAWNER, this.leftPos + 42 + 1, this.topPos + 169, 2, 12, 16, 16);
        }
    }
}

