/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.synched.SynchedEntityData;
import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPCBase;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.InteractionHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.VisibilityHandler;
import de.markusbordihn.easynpc.server.player.FakePlayer;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCBaseEntity<E extends PathfinderMob>
extends PathfinderMob
implements EasyNPCBase<E> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final EnumMap<SynchedDataIndex, EntityDataAccessor<?>> entityDataAccessorMap = new EnumMap(SynchedDataIndex.class);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private final EnumMap<TickerType, Integer> tickerMap = new EnumMap(TickerType.class);
    protected MerchantOffers merchantTradingOffers;
    private ServerEntityData serverEntityData;
    private int attackAnimationTick;
    private int npcDataVersion = -1;
    private UUID persistentAngerTarget;
    private int remainingPersistentAngerTime;
    private SynchedEntityData synchedEntityData;
    private Player tradingPlayer;
    private FakePlayer fakePlayer;

    public EasyNPCBaseEntity(EntityType<? extends PathfinderMob> entityType, Level level, Enum<?> variant) {
        super(entityType, level);
        this.registerEasyNPCDefaultHandler(variant);
        this.setInvulnerable(true);
        this.refreshGroundNavigation();
    }

    @Override
    public FakePlayer getFakePlayer(ServerLevel level, BlockPos blockPos) {
        if (FakePlayer.isInvalidFakePlayer(this.fakePlayer)) {
            this.fakePlayer = new FakePlayer(level, blockPos);
            return this.fakePlayer;
        }
        return this.fakePlayer.updatePosition(level, blockPos);
    }

    @Override
    public int getTicker(TickerType tickerType) {
        return this.tickerMap.getOrDefault((Object)tickerType, 0);
    }

    @Override
    public void setTicker(TickerType tickerType, int ticker) {
        this.tickerMap.put(tickerType, ticker);
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    @Override
    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public boolean doHurtTarget(Entity entity) {
        this.attackAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(entity);
    }

    public void handleEntityEvent(byte flag) {
        super.handleEntityEvent(flag);
        if (flag == 4) {
            this.attackAnimationTick = 10;
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.isClientSide()) {
            this.updateSwingTime();
            if (this.attackAnimationTick > 0) {
                --this.attackAnimationTick;
            }
        } else {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    @Override
    public Player getTradingPlayer() {
        return this.tradingPlayer;
    }

    @Override
    public void setTradingPlayer(Player player) {
        this.tradingPlayer = player;
    }

    public Component getName() {
        Component component = this.getCustomName();
        return component != null ? TextUtils.removeAction(component) : this.getTypeName();
    }

    public boolean hurt(DamageSource damageSource, float damage) {
        this.handleHurtEvent(damageSource, damage);
        return super.hurt(damageSource, damage);
    }

    public void die(DamageSource damageSource) {
        this.handleDieEvent(damageSource);
        super.die(damageSource);
    }

    public Entity changeDimension(DimensionTransition dimensionTransition) {
        this.handleChangeDimensionEvent(dimensionTransition);
        return super.changeDimension(dimensionTransition);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        return InteractionHandler.handleMobInteraction(this, player, hand);
    }

    public boolean isInvisible() {
        return VisibilityHandler.handleIsInvisible(this, super.isInvisible());
    }

    public boolean isInvisibleTo(Player player) {
        return VisibilityHandler.handleIsInvisibleToPlayer(this, player, super.isInvisibleTo(player));
    }

    @Override
    public int getNPCDataVersion() {
        return this.npcDataVersion;
    }

    @Override
    public void setNPCDataVersion(int version) {
        this.npcDataVersion = version;
    }

    @Override
    public MerchantOffers getMerchantTradingOffers() {
        return this.merchantTradingOffers;
    }

    @Override
    public void setMerchantTradingOffers(MerchantOffers merchantOffers) {
        this.merchantTradingOffers = merchantOffers;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficulty, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData) {
        return this.finalizeEasyNPCSpawn(super.finalizeSpawn(serverLevelAccessor, difficulty, mobSpawnType, spawnGroupData));
    }

    @Override
    public void handleEasyNPCJoin(EasyNPC<?> easyNPC) {
        this.onEasyNPCJoinUpdateObjective(easyNPC);
    }

    @Override
    public void handleEasyNPCLeave(EasyNPC<?> easyNPC) {
        this.onEasyNPCLeaveUpdateObjective(easyNPC);
    }

    @Override
    public void handlePlayerJoin(ServerPlayer serverPlayer) {
        this.onPlayerJoinUpdateObjective(serverPlayer);
    }

    @Override
    public void handlePlayerLeave(ServerPlayer serverPlayer) {
        this.onPlayerLeaveUpdateObjective(serverPlayer);
    }

    @Override
    public void handleLivingEntityJoin(LivingEntity livingEntity) {
        this.onLivingEntityJoinUpdateObjective(livingEntity);
    }

    @Override
    public void handleLivingEntityLeave(LivingEntity livingEntity) {
        this.onLivingEntityLeaveUpdateObjective(livingEntity);
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem projectileWeaponItem) {
        return AttackHandler.canFireProjectileWeapon(projectileWeaponItem);
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int remainingPersistentAngerTime) {
        this.remainingPersistentAngerTime = remainingPersistentAngerTime;
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(UUID targetUUID) {
        this.persistentAngerTarget = targetUUID;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    public GoalSelector getEntityGoalSelector() {
        return this.goalSelector;
    }

    @Override
    public GoalSelector getEntityTargetSelector() {
        return this.targetSelector;
    }

    @Override
    public <T> void defineSynchedEntityData(SynchedEntityData.Builder builder, SynchedDataIndex synchedDataIndex, T defaultData) {
        if (this.synchedEntityData == null) {
            this.synchedEntityData = new SynchedEntityData((Entity)this, entityDataAccessorMap);
        }
        this.synchedEntityData.define(builder, synchedDataIndex, defaultData);
    }

    @Override
    public <T> void setSynchedEntityData(SynchedDataIndex synchedDataIndex, T data) {
        this.synchedEntityData.set(synchedDataIndex, data);
    }

    @Override
    public <T> T getSynchedEntityData(SynchedDataIndex synchedDataIndex) {
        return this.synchedEntityData.get(synchedDataIndex);
    }

    @Override
    public void defineServerEntityData() {
        this.serverEntityData = new ServerEntityData((Entity)this);
    }

    @Override
    public ServerEntityData getServerEntityData() {
        if (this.serverEntityData == null) {
            this.defineServerEntityData();
        }
        return this.serverEntityData;
    }

    public boolean canBeLeashed() {
        return super.canBeLeashed() && this.getEntityAttributes().getInteractionAttributes().canBeLeashed();
    }

    public boolean isAttackable() {
        return this.getEntityAttributes().getCombatAttributes().isAttackable();
    }

    public boolean isPushable() {
        return this.getEntityAttributes().getInteractionAttributes().isPushable();
    }

    protected void pushEntities() {
        if (this.getEntityAttributes().getInteractionAttributes().pushEntities()) {
            super.pushEntities();
        }
    }

    public boolean isInvulnerable() {
        return !this.getEntityAttributes().getCombatAttributes().isAttackable();
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        return this.isInvulnerable() || super.isInvulnerableTo(damageSource);
    }

    public void playAmbientSound() {
        this.playDefaultAmbientSound();
    }

    public int getAmbientSoundInterval() {
        return 240;
    }

    public void playHurtSound(DamageSource damageSource) {
        this.playDefaultHurtSound(damageSource);
    }

    protected void playStepSound(BlockPos blockPos, BlockState blockState) {
        this.playDefaultStepSound(blockPos, blockState);
    }

    public SoundEvent getDeathSound() {
        return this.getDefaultDeathSound();
    }

    protected void handlePortal() {
        if (this.getEntityAttributes().getMovementAttributes().canUseNetherPortal()) {
            super.handlePortal();
        }
    }

    public boolean removeWhenFarAway(double distance) {
        return false;
    }

    public void baseTick() {
        super.baseTick();
        if (this.isClientSide() || !this.isAlive()) {
            return;
        }
        this.handleCustomObjectiveBaseTick();
        this.handleBaseTick();
    }

    public void travel(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.travel(vec3);
        } else {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
    }

    public boolean isSaddleable() {
        return false;
    }

    public void equipSaddle(ItemStack itemStack, SoundSource soundSource) {
        if (soundSource != null) {
            this.level().playSound(null, (Entity)this, SoundEvents.PIG_SADDLE, soundSource, 0.5f, 1.0f);
        }
    }

    public boolean isSaddled() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.defineEasyNPCBaseSyncedData(builder);
        this.defineEasyNPCBaseServerSideData();
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        this.addPersistentAngerSaveData(compoundTag);
        this.addEasyNPCBaseAdditionalSaveData(compoundTag, (HolderLookup.Provider)this.registryAccess());
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.readPersistentAngerSaveData(this.level(), compoundTag);
        this.readEasyNPCBaseAdditionalSaveData(compoundTag, (HolderLookup.Provider)this.registryAccess());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EasyNPCBaseEntity)) {
            return false;
        }
        EasyNPCBaseEntity easyNPCBaseEntity = (EasyNPCBaseEntity)object;
        return Objects.equals(this.getUUID(), easyNPCBaseEntity.getUUID());
    }

    public int hashCode() {
        return Objects.hash(this.getUUID());
    }

    static {
        EasyNPCBase.registerEasyNPCSyncedData(entityDataAccessorMap, EasyNPCBaseEntity.class);
    }
}

