/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;

public class ResetLookAtPlayerGoal<T extends EasyNPC<?>>
extends Goal {
    private final ModelData<?> modelData;
    private final LookControl lookControl;
    private int resetLookTime = 40;

    public ResetLookAtPlayerGoal(T easyNPC) {
        this.modelData = easyNPC.getEasyNPCModelData();
        this.lookControl = easyNPC.getLookControl();
    }

    public void start() {
        this.resetLookTime = 40;
    }

    public void stop() {
        this.resetLookTime = 0;
    }

    public boolean canUse() {
        return this.modelData == null || !this.modelData.getModelLockRotation();
    }

    public boolean canContinueToUse() {
        return (this.modelData == null || !this.modelData.getModelLockRotation()) && this.resetLookTime > 0;
    }

    public void tick() {
        if ((this.modelData == null || this.modelData.getModelLockRotation()) && this.resetLookTime > 0) {
            if (this.lookControl != null) {
                this.lookControl.setLookAt(0.0, 0.0, 0.0);
            }
            --this.resetLookTime;
        }
    }
}

