/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;

public interface ModelVisibilityData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_MODEL_VISIBLE_TAG = "Visible";

    public static void registerSyncedModelVisibilityData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Model Visibility Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_HEAD_VISIBLE, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.BOOLEAN));
        map.put(SynchedDataIndex.MODEL_BODY_VISIBLE, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.BOOLEAN));
        map.put(SynchedDataIndex.MODEL_ARMS_VISIBLE, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.BOOLEAN));
        map.put(SynchedDataIndex.MODEL_LEFT_ARM_VISIBLE, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.BOOLEAN));
        map.put(SynchedDataIndex.MODEL_RIGHT_ARM_VISIBLE, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.BOOLEAN));
        map.put(SynchedDataIndex.MODEL_LEFT_LEG_VISIBLE, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.BOOLEAN));
        map.put(SynchedDataIndex.MODEL_RIGHT_LEG_VISIBLE, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.BOOLEAN));
        map.put(SynchedDataIndex.MODEL_HELMET_VISIBLE, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.BOOLEAN));
        map.put(SynchedDataIndex.MODEL_CHESTPLATE_VISIBLE, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.BOOLEAN));
        map.put(SynchedDataIndex.MODEL_LEGGINGS_VISIBLE, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.BOOLEAN));
        map.put(SynchedDataIndex.MODEL_BOOTS_VISIBLE, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.BOOLEAN));
    }

    public boolean hasHeadModelPart();

    public boolean hasBodyModelPart();

    public boolean hasArmsModelPart();

    public boolean hasLeftArmModelPart();

    public boolean hasRightArmModelPart();

    public boolean hasLeftLegModelPart();

    public boolean hasRightLegModelPart();

    public boolean canUseArmor();

    default public boolean isModelPartVisible(ModelPart modelPart) {
        return switch (modelPart) {
            case ModelPart.HEAD -> this.isModelHeadVisible();
            case ModelPart.BODY -> this.isModelBodyVisible();
            case ModelPart.ARMS -> this.isModelArmsVisible();
            case ModelPart.LEFT_ARM -> this.isModelLeftArmVisible();
            case ModelPart.RIGHT_ARM -> this.isModelRightArmVisible();
            case ModelPart.LEFT_LEG -> this.isModelLeftLegVisible();
            case ModelPart.RIGHT_LEG -> this.isModelRightLegVisible();
            default -> false;
        };
    }

    default public boolean isModelEquipmentVisible(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == null || !this.canUseArmor()) {
            return false;
        }
        return switch (equipmentSlot) {
            case EquipmentSlot.HEAD -> this.isModelHelmetVisible();
            case EquipmentSlot.CHEST -> this.isModelChestplateVisible();
            case EquipmentSlot.LEGS -> this.isModelLeggingsVisible();
            case EquipmentSlot.FEET -> this.isModelBootsVisible();
            default -> false;
        };
    }

    default public void setModelPartVisible(ModelPart modelPart, boolean visible) {
        if (modelPart == ModelPart.ROOT) {
            return;
        }
        switch (modelPart) {
            case HEAD: {
                this.setModelHeadVisible(visible);
                break;
            }
            case BODY: {
                this.setModelBodyVisible(visible);
                break;
            }
            case ARMS: {
                this.setModelArmsVisible(visible);
                break;
            }
            case LEFT_ARM: {
                this.setModelLeftArmVisible(visible);
                break;
            }
            case RIGHT_ARM: {
                this.setModelRightArmVisible(visible);
                break;
            }
            case LEFT_LEG: {
                this.setModelLeftLegVisible(visible);
                break;
            }
            case RIGHT_LEG: {
                this.setModelRightLegVisible(visible);
                break;
            }
            default: {
                log.error("Invalid visible model part {} for {}", (Object)modelPart, (Object)this);
            }
        }
    }

    default public boolean hasChangedModelVisibility() {
        return this.hasHeadModelPart() && !this.isModelHeadVisible() || this.hasBodyModelPart() && !this.isModelBodyVisible() || this.hasArmsModelPart() && !this.isModelArmsVisible() || this.hasLeftArmModelPart() && !this.isModelLeftArmVisible() || this.hasRightArmModelPart() && !this.isModelRightArmVisible() || this.hasLeftLegModelPart() && !this.isModelLeftLegVisible() || this.hasRightLegModelPart() && !this.isModelRightLegVisible();
    }

    default public boolean isModelHeadVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_HEAD_VISIBLE);
    }

    default public void setModelHeadVisible(boolean modelHeadVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_HEAD_VISIBLE, modelHeadVisible);
    }

    default public boolean isModelBodyVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_BODY_VISIBLE);
    }

    default public void setModelBodyVisible(boolean modelBodyVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_BODY_VISIBLE, modelBodyVisible);
    }

    default public boolean isModelArmsVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_ARMS_VISIBLE);
    }

    default public void setModelArmsVisible(boolean modelArmsVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_ARMS_VISIBLE, modelArmsVisible);
    }

    default public boolean isModelLeftArmVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_VISIBLE);
    }

    default public void setModelLeftArmVisible(boolean modelLeftArmVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_VISIBLE, modelLeftArmVisible);
    }

    default public boolean isModelRightArmVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_VISIBLE);
    }

    default public void setModelRightArmVisible(boolean modelRightArmVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_VISIBLE, modelRightArmVisible);
    }

    default public boolean isModelLeftLegVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_VISIBLE);
    }

    default public void setModelLeftLegVisible(boolean modelLeftLegVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_VISIBLE, modelLeftLegVisible);
    }

    default public boolean isModelRightLegVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_VISIBLE);
    }

    default public void setModelRightLegVisible(boolean modelRightLegVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_VISIBLE, modelRightLegVisible);
    }

    default public boolean isModelHelmetVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_HELMET_VISIBLE);
    }

    default public void setModelHelmetVisible(boolean modelHelmetVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_HELMET_VISIBLE, modelHelmetVisible);
    }

    default public boolean isModelChestplateVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_CHESTPLATE_VISIBLE);
    }

    default public void setModelChestplateVisible(boolean modelChestplateVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_CHESTPLATE_VISIBLE, modelChestplateVisible);
    }

    default public boolean isModelLeggingsVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEGGINGS_VISIBLE);
    }

    default public void setModelLeggingsVisible(boolean modelLeggingsVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEGGINGS_VISIBLE, modelLeggingsVisible);
    }

    default public boolean isModelBootsVisible() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_BOOTS_VISIBLE);
    }

    default public void setModelBootsVisible(boolean modelBootsVisible) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_BOOTS_VISIBLE, modelBootsVisible);
    }

    default public void defineSynchedModelVisibilityData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_HEAD_VISIBLE, this.hasHeadModelPart());
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_BODY_VISIBLE, this.hasBodyModelPart());
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_ARMS_VISIBLE, this.hasArmsModelPart());
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_LEFT_ARM_VISIBLE, this.hasLeftArmModelPart());
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_RIGHT_ARM_VISIBLE, this.hasRightArmModelPart());
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_LEFT_LEG_VISIBLE, this.hasLeftLegModelPart());
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_RIGHT_LEG_VISIBLE, this.hasRightLegModelPart());
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_HELMET_VISIBLE, this.canUseArmor());
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_CHESTPLATE_VISIBLE, this.canUseArmor());
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_LEGGINGS_VISIBLE, this.canUseArmor());
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_BOOTS_VISIBLE, this.canUseArmor());
    }

    default public void addAdditionalModelVisibilityData(CompoundTag compoundTag) {
        CompoundTag visibilityTag = new CompoundTag();
        if (this.isModelHeadVisible() != this.hasHeadModelPart()) {
            visibilityTag.putBoolean(ModelPart.HEAD.getTagName(), this.isModelHeadVisible());
        }
        if (this.isModelBodyVisible() != this.hasBodyModelPart()) {
            visibilityTag.putBoolean(ModelPart.BODY.getTagName(), this.isModelBodyVisible());
        }
        if (this.isModelArmsVisible() != this.hasArmsModelPart()) {
            visibilityTag.putBoolean(ModelPart.ARMS.getTagName(), this.isModelArmsVisible());
        }
        if (this.isModelLeftArmVisible() != this.hasLeftArmModelPart()) {
            visibilityTag.putBoolean(ModelPart.LEFT_ARM.getTagName(), this.isModelLeftArmVisible());
        }
        if (this.isModelRightArmVisible() != this.hasRightArmModelPart()) {
            visibilityTag.putBoolean(ModelPart.RIGHT_ARM.getTagName(), this.isModelRightArmVisible());
        }
        if (this.isModelLeftLegVisible() != this.hasLeftLegModelPart()) {
            visibilityTag.putBoolean(ModelPart.LEFT_LEG.getTagName(), this.isModelLeftLegVisible());
        }
        if (this.isModelRightLegVisible() != this.hasRightLegModelPart()) {
            visibilityTag.putBoolean(ModelPart.RIGHT_LEG.getTagName(), this.isModelRightLegVisible());
        }
        if (this.isModelHelmetVisible() != this.canUseArmor()) {
            visibilityTag.putBoolean(ModelPart.HELMET.getTagName(), this.isModelHelmetVisible());
        }
        if (this.isModelChestplateVisible() != this.canUseArmor()) {
            visibilityTag.putBoolean(ModelPart.CHESTPLATE.getTagName(), this.isModelChestplateVisible());
        }
        if (this.isModelLeggingsVisible() != this.canUseArmor()) {
            visibilityTag.putBoolean(ModelPart.LEGGINGS.getTagName(), this.isModelLeggingsVisible());
        }
        if (this.isModelBootsVisible() != this.canUseArmor()) {
            visibilityTag.putBoolean(ModelPart.BOOTS.getTagName(), this.isModelBootsVisible());
        }
        compoundTag.put(EASY_NPC_DATA_MODEL_VISIBLE_TAG, (Tag)visibilityTag);
    }

    default public void readAdditionalModelVisibilityData(CompoundTag compoundTag) {
        if (!compoundTag.contains(EASY_NPC_DATA_MODEL_VISIBLE_TAG)) {
            return;
        }
        CompoundTag visibilityTag = compoundTag.getCompound(EASY_NPC_DATA_MODEL_VISIBLE_TAG);
        if (visibilityTag.contains(ModelPart.HEAD.getTagName())) {
            this.setModelHeadVisible(visibilityTag.getBoolean(ModelPart.HEAD.getTagName()));
        }
        if (visibilityTag.contains(ModelPart.BODY.getTagName())) {
            this.setModelBodyVisible(visibilityTag.getBoolean(ModelPart.BODY.getTagName()));
        }
        if (visibilityTag.contains(ModelPart.ARMS.getTagName())) {
            this.setModelArmsVisible(visibilityTag.getBoolean(ModelPart.ARMS.getTagName()));
        }
        if (visibilityTag.contains(ModelPart.LEFT_ARM.getTagName())) {
            this.setModelLeftArmVisible(visibilityTag.getBoolean(ModelPart.LEFT_ARM.getTagName()));
        }
        if (visibilityTag.contains(ModelPart.RIGHT_ARM.getTagName())) {
            this.setModelRightArmVisible(visibilityTag.getBoolean(ModelPart.RIGHT_ARM.getTagName()));
        }
        if (visibilityTag.contains(ModelPart.LEFT_LEG.getTagName())) {
            this.setModelLeftLegVisible(visibilityTag.getBoolean(ModelPart.LEFT_LEG.getTagName()));
        }
        if (visibilityTag.contains(ModelPart.RIGHT_LEG.getTagName())) {
            this.setModelRightLegVisible(visibilityTag.getBoolean(ModelPart.RIGHT_LEG.getTagName()));
        }
        if (visibilityTag.contains(ModelPart.HELMET.getTagName())) {
            this.setModelHelmetVisible(visibilityTag.getBoolean(ModelPart.HELMET.getTagName()));
        }
        if (visibilityTag.contains(ModelPart.CHESTPLATE.getTagName())) {
            this.setModelChestplateVisible(visibilityTag.getBoolean(ModelPart.CHESTPLATE.getTagName()));
        }
        if (visibilityTag.contains(ModelPart.LEGGINGS.getTagName())) {
            this.setModelLeggingsVisible(visibilityTag.getBoolean(ModelPart.LEGGINGS.getTagName()));
        }
        if (visibilityTag.contains(ModelPart.BOOTS.getTagName())) {
            this.setModelBootsVisible(visibilityTag.getBoolean(ModelPart.BOOTS.getTagName()));
        }
    }
}

